/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.bloom;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.druid.query.aggregation.bloom.BloomFilterMergeAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;

public class BloomFilterMergeAggregatorFactory
extends BloomFilterAggregatorFactory {
    private final String fieldName;

    BloomFilterMergeAggregatorFactory(String name, String field, Integer maxNumEntries) {
        super(name, null, maxNumEntries);
        this.fieldName = field;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return this.makeMergeAggregator(metricFactory);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return this.makeMergeAggregator(metricFactory);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new BloomFilterMergeAggregatorFactory(this.getName(), this.fieldName, (Integer)this.getMaxNumEntries()));
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(53).appendString(this.fieldName).appendInt(this.getMaxNumEntries()).build();
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new BloomFilterMergeAggregatorFactory(newName, this.fieldName, (Integer)this.getMaxNumEntries());
    }

    private BloomFilterMergeAggregator makeMergeAggregator(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            throw new ISE("Unexpected NilColumnValueSelector", new Object[0]);
        }
        return new BloomFilterMergeAggregator((BaseObjectColumnValueSelector<ByteBuffer>)selector, this.getMaxNumEntries(), true);
    }
}

