/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.s3.S3DataSegmentPusherConfig;
import org.apache.druid.storage.s3.S3InputDataConfig;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.timeline.DataSegment;

public class S3DataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(S3DataSegmentKiller.class);
    private final Supplier<ServerSideEncryptingAmazonS3> s3ClientSupplier;
    private final S3DataSegmentPusherConfig segmentPusherConfig;
    private final S3InputDataConfig inputDataConfig;

    @Inject
    public S3DataSegmentKiller(Supplier<ServerSideEncryptingAmazonS3> s3Client, S3DataSegmentPusherConfig segmentPusherConfig, S3InputDataConfig inputDataConfig) {
        this.s3ClientSupplier = s3Client;
        this.segmentPusherConfig = segmentPusherConfig;
        this.inputDataConfig = inputDataConfig;
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        try {
            Map loadSpec = segment.getLoadSpec();
            String s3Bucket = MapUtils.getString((Map)loadSpec, (String)"bucket");
            String s3Path = MapUtils.getString((Map)loadSpec, (String)"key");
            String s3DescriptorPath = DataSegmentKiller.descriptorPath((String)s3Path);
            ServerSideEncryptingAmazonS3 s3Client = (ServerSideEncryptingAmazonS3)this.s3ClientSupplier.get();
            if (s3Client.doesObjectExist(s3Bucket, s3Path)) {
                log.info("Removing index file[s3://%s/%s] from s3!", new Object[]{s3Bucket, s3Path});
                s3Client.deleteObject(s3Bucket, s3Path);
            }
            if (s3Client.doesObjectExist(s3Bucket, s3DescriptorPath)) {
                log.info("Removing descriptor file[s3://%s/%s] from s3!", new Object[]{s3Bucket, s3DescriptorPath});
                s3Client.deleteObject(s3Bucket, s3DescriptorPath);
            }
        }
        catch (AmazonServiceException e) {
            throw new SegmentLoadingException((Throwable)e, "Couldn't kill segment[%s]: [%s]", new Object[]{segment.getId(), e});
        }
    }

    public void killAll() throws IOException {
        if (this.segmentPusherConfig.getBucket() == null || this.segmentPusherConfig.getBaseKey() == null) {
            throw new ISE("Cannot delete all segment from S3 Deep Storage since druid.storage.bucket and druid.storage.baseKey are not both set.", new Object[0]);
        }
        log.info("Deleting all segment files from s3 location [bucket: '%s' prefix: '%s']", new Object[]{this.segmentPusherConfig.getBucket(), this.segmentPusherConfig.getBaseKey()});
        try {
            S3Utils.deleteObjectsInPath((ServerSideEncryptingAmazonS3)this.s3ClientSupplier.get(), this.inputDataConfig, this.segmentPusherConfig.getBucket(), this.segmentPusherConfig.getBaseKey(), (Predicate<S3ObjectSummary>)Predicates.alwaysTrue());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting segment files from s3. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

