/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.firehose.s3;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.prefetch.PrefetchableTextFilesFirehoseFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.utils.CompressionUtils;

public class StaticS3FirehoseFactory
extends PrefetchableTextFilesFirehoseFactory<URI> {
    private static final Logger log = new Logger(StaticS3FirehoseFactory.class);
    private static final int MAX_LISTING_LENGTH = 1024;
    private final ServerSideEncryptingAmazonS3 s3Client;
    private final List<URI> uris;
    private final List<URI> prefixes;

    @JsonCreator
    public StaticS3FirehoseFactory(@JacksonInject ServerSideEncryptingAmazonS3 s3Client, @JsonProperty(value="uris") List<URI> uris, @JsonProperty(value="prefixes") List<URI> prefixes, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="maxFetchRetry") Integer maxFetchRetry) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, maxFetchRetry);
        this.s3Client = (ServerSideEncryptingAmazonS3)Preconditions.checkNotNull((Object)s3Client, (Object)"s3Client");
        this.uris = uris == null ? new ArrayList() : uris;
        ArrayList arrayList = this.prefixes = prefixes == null ? new ArrayList() : prefixes;
        if (!this.uris.isEmpty() && !this.prefixes.isEmpty()) {
            throw new IAE("uris and prefixes cannot be used together", new Object[0]);
        }
        if (this.uris.isEmpty() && this.prefixes.isEmpty()) {
            throw new IAE("uris or prefixes must be specified", new Object[0]);
        }
        for (URI inputURI : this.uris) {
            Preconditions.checkArgument((boolean)"s3".equals(inputURI.getScheme()), (String)"input uri scheme == s3 (%s)", (Object[])new Object[]{inputURI});
        }
        for (URI inputURI : this.prefixes) {
            Preconditions.checkArgument((boolean)"s3".equals(inputURI.getScheme()), (String)"input uri scheme == s3 (%s)", (Object[])new Object[]{inputURI});
        }
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    @JsonProperty(value="prefixes")
    public List<URI> getPrefixes() {
        return this.prefixes;
    }

    protected Collection<URI> initObjects() {
        if (!this.uris.isEmpty()) {
            return this.uris;
        }
        ArrayList objects = new ArrayList();
        for (URI prefix : this.prefixes) {
            Iterator<S3ObjectSummary> objectSummaryIterator = S3Utils.objectSummaryIterator(this.s3Client, Collections.singletonList(prefix), 1024);
            objectSummaryIterator.forEachRemaining(objects::add);
        }
        return objects.stream().map(S3Utils::summaryToUri).collect(Collectors.toList());
    }

    protected InputStream openObjectStream(URI object) throws IOException {
        try {
            String bucket = object.getAuthority();
            String key = S3Utils.extractS3Key(object);
            S3Object s3Object = this.s3Client.getObject(bucket, key);
            if (s3Object == null) {
                throw new ISE("Failed to get an s3 object for bucket[%s] and key[%s]", new Object[]{bucket, key});
            }
            return s3Object.getObjectContent();
        }
        catch (AmazonS3Exception e) {
            throw new IOException(e);
        }
    }

    protected InputStream openObjectStream(URI object, long start) throws IOException {
        String bucket = object.getAuthority();
        String key = S3Utils.extractS3Key(object);
        GetObjectRequest request = new GetObjectRequest(bucket, key);
        request.setRange(start);
        try {
            S3Object s3Object = this.s3Client.getObject(request);
            if (s3Object == null) {
                throw new ISE("Failed to get an s3 object for bucket[%s], key[%s], and start[%d]", new Object[]{bucket, key, start});
            }
            return s3Object.getObjectContent();
        }
        catch (AmazonS3Exception e) {
            throw new IOException(e);
        }
    }

    protected InputStream wrapObjectStream(URI object, InputStream stream) throws IOException {
        return CompressionUtils.decompress((InputStream)stream, (String)S3Utils.extractS3Key(object));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StaticS3FirehoseFactory that = (StaticS3FirehoseFactory)((Object)o);
        return Objects.equals(this.uris, that.uris) && Objects.equals(this.prefixes, that.prefixes) && this.getMaxCacheCapacityBytes() == that.getMaxCacheCapacityBytes() && this.getMaxFetchCapacityBytes() == that.getMaxFetchCapacityBytes() && this.getPrefetchTriggerBytes() == that.getPrefetchTriggerBytes() && this.getFetchTimeout() == that.getFetchTimeout() && this.getMaxFetchRetry() == that.getMaxFetchRetry();
    }

    public int hashCode() {
        return Objects.hash(this.uris, this.prefixes, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }

    protected Predicate<Throwable> getRetryCondition() {
        return S3Utils.S3RETRY;
    }

    public FiniteFirehoseFactory<StringInputRowParser, URI> withSplit(InputSplit<URI> split) {
        return new StaticS3FirehoseFactory(this.s3Client, Collections.singletonList(split.get()), null, this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.getMaxFetchRetry());
    }
}

