/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils.comparators;

import java.util.Comparator;

public abstract class AbstractObjectComparator<T>
implements Comparator<Object> {
    private final Class<T> cls;

    public AbstractObjectComparator(Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        this.cls = cls;
    }

    @Override
    public final int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (this.cls.isAssignableFrom(c1)) {
            T v1 = this.tryCast(o1);
            if (this.cls.isAssignableFrom(c2)) {
                T v2 = this.tryCast(o2);
                return this.comparePossibleValues(v1, v2);
            }
            return 1;
        }
        if (this.cls.isAssignableFrom(c2)) {
            return -1;
        }
        return this.compareClasses(c1, c2);
    }

    protected int compareClasses(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1.getCanonicalName() == null) {
            if (c2.getCanonicalName() == null) {
                return 0;
            }
            return -1;
        }
        if (c2.getCanonicalName() == null) {
            return 1;
        }
        return c1.getCanonicalName().compareTo(c2.getCanonicalName());
    }

    protected T tryCast(Object obj) {
        try {
            return this.cls.cast(obj);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private int comparePossibleValues(T v1, T v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return this.compareValues(v1, v2);
    }

    protected abstract int compareValues(T var1, T var2);
}

