/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractElement
extends org.apache.batik.dom.AbstractElement
implements NodeEventTarget {
    protected transient SoftDoublyIndexedTable liveAttributeValues;

    protected AbstractElement() {
    }

    protected AbstractElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        this.setPrefix(string);
        this.initializeAttributes();
    }

    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)CSSEngine.getLogicalParentNode(this.getParentNode()));
    }

    public LiveAttributeValue getLiveAttributeValue(String string, String string2) {
        if (this.liveAttributeValues == null) {
            return null;
        }
        return (LiveAttributeValue)this.liveAttributeValues.get(string, string2);
    }

    public void putLiveAttributeValue(String string, String string2, LiveAttributeValue liveAttributeValue) {
        if (this.liveAttributeValues == null) {
            this.liveAttributeValues = new SoftDoublyIndexedTable();
        }
        this.liveAttributeValues.put(string, string2, liveAttributeValue);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return null;
    }

    protected void initializeAttributes() {
        AttributeInitializer attributeInitializer = this.getAttributeInitializer();
        if (attributeInitializer != null) {
            attributeInitializer.initializeAttributes(this);
        }
    }

    protected boolean resetAttribute(String string, String string2, String string3) {
        AttributeInitializer attributeInitializer = this.getAttributeInitializer();
        if (attributeInitializer == null) {
            return false;
        }
        return attributeInitializer.resetAttribute(this, string, string2, string3);
    }

    protected NamedNodeMap createAttributes() {
        return new ExtendedNamedNodeHashMap();
    }

    public void setUnspecifiedAttribute(String string, String string2, String string3) {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        ((ExtendedNamedNodeHashMap)this.attributes).setUnspecifiedAttribute(string, string2, string3);
    }

    protected void attrAdded(Attr attr, String string) {
        LiveAttributeValue liveAttributeValue = this.getLiveAttributeValue(attr);
        if (liveAttributeValue != null) {
            liveAttributeValue.attrAdded(attr, string);
        }
    }

    protected void attrModified(Attr attr, String string, String string2) {
        LiveAttributeValue liveAttributeValue = this.getLiveAttributeValue(attr);
        if (liveAttributeValue != null) {
            liveAttributeValue.attrModified(attr, string, string2);
        }
    }

    protected void attrRemoved(Attr attr, String string) {
        LiveAttributeValue liveAttributeValue = this.getLiveAttributeValue(attr);
        if (liveAttributeValue != null) {
            liveAttributeValue.attrRemoved(attr, string);
        }
    }

    private LiveAttributeValue getLiveAttributeValue(Attr attr) {
        String string;
        return this.getLiveAttributeValue(string, (string = attr.getNamespaceURI()) == null ? attr.getNodeName() : attr.getLocalName());
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        ((AbstractElement)node).initializeAttributes();
        super.export(node, abstractDocument);
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        ((AbstractElement)node).initializeAttributes();
        super.deepExport(node, abstractDocument);
        return node;
    }

    protected class ExtendedNamedNodeHashMap
    extends AbstractElement.NamedNodeHashMap {
        public void setUnspecifiedAttribute(String string, String string2, String string3) {
            Attr attr = AbstractElement.this.getOwnerDocument().createAttributeNS(string, string2);
            attr.setValue(string3);
            ((AbstractAttr)attr).setSpecified(false);
            this.setNamedItemNS(attr);
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            AbstractAttr abstractAttr = (AbstractAttr)this.remove(string, string2);
            if (abstractAttr == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            String string3 = abstractAttr.getPrefix();
            if (!AbstractElement.this.resetAttribute(string, string3, string2)) {
                AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            }
            return abstractAttr;
        }
    }
}

