/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class Derby5624Test
extends BaseJDBCTestCase {
    public Derby5624Test(String string) {
        super(string);
    }

    public void testDERBY_5624() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO TESTBIGTABLE (col1, col2, col3) VALUES(?, ?, ?)");
        for (n = 0; n < 3000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, -n);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
        }
        this.commit();
        for (n = 0; n < 1000; ++n) {
            statement.executeUpdate("CREATE INDEX INDEXBIG" + n + " on TESTBIGTABLE (col" + n + ")");
        }
        this.commit();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TESTBIGTABLE', 0)");
        this.commit();
        JDBC.assertUnorderedResultSet(this.prepareStatement("select col1, col2 from TESTBIGTABLE where col1 = 10").executeQuery(), new String[][]{{"10", "-10"}});
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby5624Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                StringBuffer stringBuffer = new StringBuffer(10000);
                stringBuffer.append("CREATE TABLE TESTBIGTABLE (col0 int");
                for (int i = 1; i < 1000; ++i) {
                    stringBuffer.append(", col" + i + " int");
                }
                stringBuffer.append(")");
                statement.executeUpdate(stringBuffer.toString());
                connection.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby5624Test");
        baseTestSuite.addTest(Derby5624Test.baseSuite("Derby5624Test:embedded"));
        return baseTestSuite;
    }
}

