/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.mail;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public final class SMTPMail {
    public static void main(String[] args) {
        ArrayList<String> ccList = new ArrayList<String>();
        FileReader fileReader = null;
        if (args.length < 1) {
            System.err.println("Usage: SMTPMail <smtpserver>");
            System.exit(1);
        }
        String server = args[0];
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.print("From: ");
            System.out.flush();
            String sender = stdin.readLine();
            System.out.print("To: ");
            System.out.flush();
            String recipient = stdin.readLine();
            System.out.print("Subject: ");
            System.out.flush();
            String subject = stdin.readLine();
            SimpleSMTPHeader header = new SimpleSMTPHeader(sender, recipient, subject);
            while (true) {
                System.out.print("CC <enter one address per line, hit enter to end>: ");
                System.out.flush();
                String cc = stdin.readLine();
                if (cc == null || cc.isEmpty()) break;
                header.addCC(cc.trim());
                ccList.add(cc.trim());
            }
            System.out.print("Filename: ");
            System.out.flush();
            String fileName = stdin.readLine();
            try {
                fileReader = new FileReader(fileName);
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found. " + e.getMessage());
            }
            SMTPClient client = new SMTPClient();
            client.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out), true));
            client.connect(server);
            if (!SMTPReply.isPositiveCompletion(client.getReplyCode())) {
                client.disconnect();
                System.err.println("SMTP server refused connection.");
                System.exit(1);
            }
            client.login();
            client.setSender(sender);
            client.addRecipient(recipient);
            for (String recpt : ccList) {
                client.addRecipient(recpt);
            }
            Writer writer = client.sendMessageData();
            if (writer != null) {
                writer.write(header.toString());
                Util.copyReader(fileReader, writer);
                writer.close();
                client.completePendingCommand();
            }
            if (fileReader != null) {
                fileReader.close();
            }
            client.logout();
            client.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

