/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.android;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class GeolocationDetector
implements Detector {
    private static final boolean DEBUG = false;
    private static final String ANDROID_GEOLOCATION_TYPE = "ANDROID_GEOLOCATION";
    private final BugReporter bugReporter;

    public GeolocationDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        boolean isWebChromeClient = InterfaceUtils.isSubtype(javaClass, "android.webkit.WebChromeClient");
        if (!isWebChromeClient) {
            return;
        }
        for (Method m : methodList = javaClass.getMethods()) {
            if (!m.getName().equals("onGeolocationPermissionsShowPrompt")) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, ANDROID_GEOLOCATION_TYPE, 2).addClassAndMethod(javaClass, m));
        }
    }

    public void report() {
    }
}

