/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class StrutsValidatorFormDetector
implements Detector {
    private static final String STRUTS_FORM_VALIDATION_TYPE = "STRUTS_FORM_VALIDATION";
    private BugReporter bugReporter;

    public StrutsValidatorFormDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        boolean isActionForm = InterfaceUtils.isSubtype(javaClass, "org.apache.struts.action.ActionForm");
        boolean isValidatorForm = InterfaceUtils.isSubtype(javaClass, "org.apache.struts.validator.ValidatorForm");
        boolean isDynaValidatorForm = InterfaceUtils.isSubtype(javaClass, "org.apache.struts.validator.DynaValidatorForm");
        if (!(isActionForm || isValidatorForm || isDynaValidatorForm)) {
            return;
        }
        String expectedSig = "(Lorg/apache/struts/action/ActionMapping;Ljavax/servlet/http/HttpServletRequest;)Lorg/apache/struts/action/ActionErrors;";
        boolean validateMethodFound = false;
        for (Method m : javaClass.getMethods()) {
            if (!"validate".equals(m.getName()) || !"(Lorg/apache/struts/action/ActionMapping;Ljavax/servlet/http/HttpServletRequest;)Lorg/apache/struts/action/ActionErrors;".equals(m.getSignature())) continue;
            validateMethodFound = true;
        }
        if (!validateMethodFound) {
            BugInstance bug = new BugInstance((Detector)this, STRUTS_FORM_VALIDATION_TYPE, 3).addClass(javaClass);
            if (isActionForm) {
                bug.addString("ActionForm");
            } else if (isValidatorForm) {
                bug.addString("ValidatorForm");
            } else if (isDynaValidatorForm) {
                bug.addString("DynaValidatorForm");
            }
            this.bugReporter.reportBug(bug);
        }
    }

    public void report() {
    }
}

