/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.cdi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs3.jcache.cdi.CDIJCacheHelper;
import org.junit.Assert;
import org.junit.Test;

public class CDIJCacheHelperTest {
    @Test
    public void proxyCacheDefaults() {
        CDIJCacheHelper helper = new CDIJCacheHelper();
        MyParent child1 = (MyParent)MyParent.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MyChild1.class}, (proxy, method, args) -> null));
        CDIJCacheHelper.MethodMeta meta1 = helper.findMeta(this.newContext(child1));
        Assert.assertEquals((Object)"child", (Object)meta1.getCacheResultCacheName());
        MyParent child2 = (MyParent)MyParent.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{MyChild2.class}, (proxy, method, args) -> null));
        CDIJCacheHelper.MethodMeta meta2 = helper.findMeta(this.newContext(child2));
        Assert.assertEquals((Object)"child2", (Object)meta2.getCacheResultCacheName());
    }

    private InvocationContext newContext(final MyParent child1) {
        return new InvocationContext(){

            public Object getTarget() {
                return child1;
            }

            public Method getMethod() {
                try {
                    return MyParent.class.getMethod("foo", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }

            public Constructor<?> getConstructor() {
                return null;
            }

            public Object[] getParameters() {
                return new Object[0];
            }

            public void setParameters(Object[] objects) {
            }

            public Map<String, Object> getContextData() {
                return null;
            }

            public Object proceed() throws Exception {
                return null;
            }

            public Object getTimer() {
                return null;
            }
        };
    }

    @CacheDefaults(cacheName="child2")
    public static interface MyChild2
    extends MyParent {
    }

    @CacheDefaults(cacheName="child")
    public static interface MyChild1
    extends MyParent {
    }

    public static interface MyParent {
        @CacheResult
        public String foo();
    }
}

