/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.extras.web;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs3.jcache.extras.web.InMemoryResponse;

public class JCacheFilter
implements Filter {
    private Cache<PageKey, Page> cache;
    private CachingProvider provider;
    private CacheManager manager;

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoader classLoader = filterConfig.getServletContext().getClassLoader();
        this.provider = Caching.getCachingProvider((ClassLoader)classLoader);
        String uri = filterConfig.getInitParameter("configuration");
        if (uri == null) {
            uri = this.provider.getDefaultURI().toString();
        }
        Properties properties = new Properties();
        for (String key : Collections.list(filterConfig.getInitParameterNames())) {
            String value = filterConfig.getInitParameter(key);
            if (value == null) continue;
            properties.put(key, value);
        }
        this.manager = this.provider.getCacheManager(URI.create(uri), classLoader, properties);
        String cacheName = filterConfig.getInitParameter("cache-name");
        if (cacheName == null) {
            cacheName = JCacheFilter.class.getName();
        }
        this.cache = this.manager.getCache(cacheName);
        if (this.cache == null) {
            String expirtyPolicy;
            MutableConfiguration configuration = new MutableConfiguration().setStoreByValue(false);
            configuration.setReadThrough("true".equals(properties.getProperty("read-through", "false")));
            configuration.setWriteThrough("true".equals(properties.getProperty("write-through", "false")));
            if (configuration.isReadThrough()) {
                configuration.setCacheLoaderFactory((Factory)new FactoryBuilder.ClassFactory(properties.getProperty("cache-loader-factory")));
            }
            if (configuration.isWriteThrough()) {
                configuration.setCacheWriterFactory((Factory)new FactoryBuilder.ClassFactory(properties.getProperty("cache-writer-factory")));
            }
            if ((expirtyPolicy = properties.getProperty("expiry-policy-factory")) != null) {
                configuration.setExpiryPolicyFactory((Factory)new FactoryBuilder.ClassFactory(expirtyPolicy));
            }
            configuration.setManagementEnabled("true".equals(properties.getProperty("management-enabled", "false")));
            configuration.setStatisticsEnabled("true".equals(properties.getProperty("statistics-enabled", "false")));
            this.cache = this.manager.createCache(cacheName, (Configuration)configuration);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean gzip = false;
        if (HttpServletRequest.class.isInstance(servletRequest)) {
            Enumeration acceptEncoding = ((HttpServletRequest)HttpServletRequest.class.cast(servletRequest)).getHeaders("Accept-Encoding");
            while (acceptEncoding != null && acceptEncoding.hasMoreElements()) {
                if (!"gzip".equals(acceptEncoding.nextElement())) continue;
                gzip = true;
                break;
            }
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)HttpServletResponse.class.cast(servletResponse);
        JCacheFilter.checkResponse((ServletResponse)httpServletResponse);
        PageKey key = new PageKey(this.key(servletRequest), gzip);
        Page page = (Page)this.cache.get((Object)key);
        if (page == null) {
            Iterator baos = new ByteArrayOutputStream();
            InMemoryResponse response = gzip ? new InMemoryResponse(httpServletResponse, new GZIPOutputStream((OutputStream)((Object)baos))) : new InMemoryResponse(httpServletResponse, (OutputStream)((Object)baos));
            filterChain.doFilter(servletRequest, (ServletResponse)response);
            response.flushBuffer();
            page = new Page(response.getStatus(), response.getContentType(), response.getContentLength(), response.getCookies(), response.getHeaders(), ((ByteArrayOutputStream)((Object)baos)).toByteArray());
            this.cache.put((Object)key, (Object)page);
        }
        if (page.status == 200) {
            JCacheFilter.checkResponse((ServletResponse)httpServletResponse);
            if (gzip) {
                httpServletResponse.setHeader("Content-Encoding", "gzip");
            }
            httpServletResponse.setStatus(page.status);
            if (page.contentType != null) {
                httpServletResponse.setContentType(page.contentType);
            }
            if (page.contentLength > 0) {
                httpServletResponse.setContentLength(page.contentLength);
            }
            for (Cookie c : page.cookies) {
                httpServletResponse.addCookie(c);
            }
            for (Map.Entry entry : page.headers.entrySet()) {
                for (Serializable value : (List)entry.getValue()) {
                    if (Integer.class.isInstance(value)) {
                        httpServletResponse.addIntHeader((String)entry.getKey(), ((Integer)Integer.class.cast(value)).intValue());
                        continue;
                    }
                    if (String.class.isInstance(value)) {
                        httpServletResponse.addHeader((String)entry.getKey(), (String)String.class.cast(value));
                        continue;
                    }
                    if (!Long.class.isInstance(value)) continue;
                    httpServletResponse.addDateHeader((String)entry.getKey(), ((Long)Long.class.cast(value)).longValue());
                }
            }
            httpServletResponse.setContentLength(page.out.length);
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            if (page.out.length != 0) {
                bos.write(page.out);
            } else {
                bos.write(new byte[0]);
            }
            bos.flush();
        }
    }

    protected String key(ServletRequest servletRequest) {
        if (HttpServletRequest.class.isInstance(servletRequest)) {
            HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
            return request.getMethod() + '_' + request.getRequestURI() + '_' + request.getQueryString();
        }
        return servletRequest.toString();
    }

    private static void checkResponse(ServletResponse servletResponse) {
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Response committed");
        }
    }

    public void destroy() {
        if (!this.cache.isClosed()) {
            this.cache.close();
        }
        if (!this.manager.isClosed()) {
            this.manager.close();
        }
        this.provider.close();
    }

    protected static class Page
    implements Serializable {
        private final int status;
        private final String contentType;
        private final int contentLength;
        private final Collection<Cookie> cookies;
        private final Map<String, List<Serializable>> headers;
        private final byte[] out;

        public Page(int status, String contentType, int contentLength, Collection<Cookie> cookies, Map<String, List<Serializable>> headers, byte[] out) {
            this.status = status;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.cookies = cookies;
            this.headers = headers;
            this.out = out;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) return false;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Page page = (Page)Page.class.cast(o);
            if (this.contentLength != page.contentLength) return false;
            if (this.status != page.status) return false;
            if (this.contentType != null) {
                if (!this.contentType.equals(page.contentType)) {
                    return false;
                }
            } else if (page.contentType != null) return false;
            if (!this.cookies.equals(page.cookies)) return false;
            if (!this.headers.equals(page.headers)) return false;
            if (!Arrays.equals(this.out, page.out)) return false;
            return true;
        }

        public int hashCode() {
            int result = this.status;
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + this.contentLength;
            result = 31 * result + this.cookies.hashCode();
            result = 31 * result + this.headers.hashCode();
            result = 31 * result + Arrays.hashCode(this.out);
            return result;
        }
    }

    protected static class PageKey
    implements Serializable {
        private final String uri;
        private boolean gzip;

        public PageKey(String uri, boolean gzip) {
            this.uri = uri;
            this.gzip = gzip;
        }

        public void setGzip(boolean gzip) {
            this.gzip = gzip;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)PageKey.class.cast(o);
            return this.gzip == pageKey.gzip && this.uri.equals(pageKey.uri);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + (this.gzip ? 1 : 0);
            return result;
        }
    }
}

