/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs3.auxiliary.disk.indexed.DiskTestObjectUtil;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.utils.timing.SleepUtil;

public abstract class IndexDiskCacheUnitTestAbstract
extends TestCase {
    public abstract IndexedDiskCacheAttributes getCacheAttributes();

    public void testSimplePutAndGet() throws IOException {
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testSimplePutAndGet");
        cattr.setMaxKeySize(1000);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 999;
        for (i = 0; i < 999; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement("testSimplePutAndGet", (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 0; i < 999; ++i) {
            ICacheElement element = disk.processGet((Object)("key:" + i));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have received an element.", (Object)element);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)"Element is wrong.", (String)("data:" + i), (String)((String)element.getVal()));
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i2 = 0; i2 < 999; ++i2) {
            keys.add("key:" + i2);
        }
        Map elements = disk.getMultiple(keys);
        for (int i3 = 0; i3 < 999; ++i3) {
            ICacheElement element = (ICacheElement)elements.get("key:" + i3);
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)("element " + i3 + ":key is missing"), (Object)element);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)("value key:" + i3), (String)("data:" + i3), (String)((String)element.getVal()));
        }
    }

    public void testRemoveItems() throws IOException {
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveItems");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < 25; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement("testRemoveItems", (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 0; i < 25; ++i) {
            disk.remove((Object)("key:" + i));
            ICacheElement element = disk.processGet((Object)("key:" + i));
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    public void testCheckForDedOverlaps_noOverlap() {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testCheckForDedOverlaps_noOverlap");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numDescriptors = 5;
        int pos = 0;
        IndexedDiskElementDescriptor[] sortedDescriptors = new IndexedDiskElementDescriptor[5];
        for (int i = 0; i < 5; ++i) {
            IndexedDiskElementDescriptor descriptor = new IndexedDiskElementDescriptor((long)pos, i * 2);
            pos = pos + i * 2 + 4;
            sortedDescriptors[i] = descriptor;
        }
        boolean result = disk.checkForDedOverlaps(sortedDescriptors);
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"There should be no overlap. it should be ok", (boolean)result);
    }

    public void testCheckForDedOverlaps_overlaps() {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testCheckForDedOverlaps_overlaps");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numDescriptors = 5;
        int pos = 0;
        IndexedDiskElementDescriptor[] sortedDescriptors = new IndexedDiskElementDescriptor[5];
        for (int i = 0; i < 5; ++i) {
            IndexedDiskElementDescriptor descriptor = new IndexedDiskElementDescriptor((long)pos, i * 2);
            pos += i * 2;
            sortedDescriptors[i] = descriptor;
        }
        boolean result = disk.checkForDedOverlaps(sortedDescriptors);
        IndexDiskCacheUnitTestAbstract.assertFalse((String)"There should be overlaps. it should be not ok", (boolean)result);
    }

    public void testFileSize() throws IOException, InterruptedException {
        ICacheElement<Integer, DiskTestObject>[] elements;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testFileSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numberToInsert = 20;
        int bytes = 24;
        for (ICacheElement<Integer, DiskTestObject> element : elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(20, 24, cattr.getCacheName())) {
            disk.processUpdate(element);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        long expectedSize = DiskTestObjectUtil.totalSize(elements, 20);
        long resultSize = disk.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong file size", (long)expectedSize, (long)resultSize);
    }

    public void testRecyleBinSize() throws IOException, InterruptedException {
        ICacheElement<Integer, DiskTestObject>[] elements;
        int numberToInsert = 20;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRecyleBinSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        cattr.setOptimizeAtRemoveCount(20);
        cattr.setMaxKeySize(40);
        cattr.setMaxPurgatorySize(20);
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        boolean bytes = true;
        for (ICacheElement<Integer, DiskTestObject> element : elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(20, 1, cattr.getCacheName())) {
            disk.processUpdate(element);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"The recycle bin should have the number removed.", (int)numberToRemove, (int)disk.getRecyleBinSize());
    }

    public void testRecyleBinUsage() throws IOException, InterruptedException {
        ICacheElement<Integer, DiskTestObject>[] elements;
        int numberToInsert = 20;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRecyleBinUsage");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        cattr.setOptimizeAtRemoveCount(20);
        cattr.setMaxKeySize(40);
        cattr.setMaxPurgatorySize(20);
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        boolean bytes = true;
        for (ICacheElement<Integer, DiskTestObject> element : elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(20, 1, cattr.getCacheName())) {
            disk.processUpdate(element);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"The recycle bin should have the number removed.", (int)numberToRemove, (int)disk.getRecyleBinSize());
        int numberToAdd = numberToRemove / 2;
        for (int i = 0; i < numberToAdd; ++i) {
            disk.processUpdate(elements[i]);
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("The recycle bin should have the number removed." + disk.getStats()), (int)numberToAdd, (int)disk.getRecyleCount());
    }

    public void testBytesFreeSize() throws IOException, InterruptedException {
        ICacheElement<Integer, DiskTestObject>[] elements;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testBytesFreeSize");
        cattr.setDiskPath("target/test-sandbox/UnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        int numberToInsert = 20;
        int bytes = 24;
        for (ICacheElement<Integer, DiskTestObject> element : elements = DiskTestObjectUtil.createCacheElementsWithTestObjects(20, 24, cattr.getCacheName())) {
            disk.processUpdate(element);
        }
        Thread.yield();
        Thread.sleep(100L);
        Thread.yield();
        int numberToRemove = elements.length / 2;
        for (int i = 0; i < numberToRemove; ++i) {
            disk.processRemove(elements[i].getKey());
        }
        long expectedSize = DiskTestObjectUtil.totalSize(elements, numberToRemove);
        long resultSize = disk.getBytesFree();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("Wrong bytes free size" + disk.getStats()), (long)expectedSize, (long)resultSize);
        int numberToAdd = numberToRemove / 2;
        for (int i = 0; i < numberToAdd; ++i) {
            disk.processUpdate(elements[i]);
        }
        long expectedSize2 = DiskTestObjectUtil.totalSize(elements, numberToAdd);
        long resultSize2 = disk.getBytesFree();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)("Wrong bytes free size" + disk.getStats()), (long)expectedSize2, (long)resultSize2);
    }

    public void testRemove_PartialKey() throws IOException {
        ICacheElement element;
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_PartialKey");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < 25; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element2 = new CacheElement("testRemove_PartialKey", (Object)(i + ":key"), (Object)("data:" + i));
            element2.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element2);
        }
        for (i = 0; i < 25; ++i) {
            element = disk.processGet((Object)(i + ":key"));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Shoulds have received an element.", (Object)element);
        }
        for (i = 0; i < 25; ++i) {
            disk.remove((Object)(i + ":"));
            element = disk.processGet((Object)(i + ":key"));
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Recylenbin should not have more elements than we removed. Check for JCS-67", (int)25, (int)disk.getRecyleBinSize());
    }

    public void testRemove_Group() throws IOException {
        ICacheElement element;
        GroupAttrName<String> groupAttrName;
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemove_Group");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        String cacheName = "testRemove_Group_Region";
        String groupName = "testRemove_Group";
        int cnt = 25;
        for (i = 0; i < 25; ++i) {
            groupAttrName = this.getGroupAttrName("testRemove_Group_Region", "testRemove_Group", i + ":key");
            element = new CacheElement("testRemove_Group_Region", groupAttrName, (Object)("data:" + i));
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate(element);
        }
        for (i = 0; i < 25; ++i) {
            groupAttrName = this.getGroupAttrName("testRemove_Group_Region", "testRemove_Group", i + ":key");
            element = disk.processGet(groupAttrName);
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have received an element.", (Object)element);
        }
        disk.remove(this.getGroupAttrName("testRemove_Group_Region", "testRemove_Group", null));
        for (i = 0; i < 25; ++i) {
            groupAttrName = this.getGroupAttrName("testRemove_Group_Region", "testRemove_Group", i + ":key");
            element = disk.processGet(groupAttrName);
            IndexDiskCacheUnitTestAbstract.assertNull((String)"Should not have received an element.", (Object)element);
        }
    }

    private GroupAttrName<String> getGroupAttrName(String cacheName, String group, String name) {
        GroupId gid = new GroupId(cacheName, group);
        return new GroupAttrName(gid, (Object)name);
    }

    public void testUpdate_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testUpdate_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        CacheElement item = new CacheElement("region", (Object)"key", (Object)"value");
        diskCache.update((ICacheElement)item);
        SleepUtil.sleepAtLeast(200L);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGet_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testGet_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.get((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testGetMultiple_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testGetMultiple_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        HashSet<String> keys = new HashSet<String>();
        keys.add("junk");
        diskCache.getMultiple(keys);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)2, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)2, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemove_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveAll_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.remove((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testRemoveAll_EventLogging_simple() throws Exception {
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveAll_EventLogging_simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTestCEL");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.processRemoveAll();
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        diskCache.setCacheEventLogger((ICacheEventLogger)cacheEventLogger);
        diskCache.remove((Object)"key");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Start should have been called.", (int)1, (int)cacheEventLogger.startICacheEventCalls);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"End should have been called.", (int)1, (int)cacheEventLogger.endICacheEventCalls);
    }

    public void testPutGetMatching_SmallWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_SmallWait";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testPutGetMatching_SmallWait");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (int i = 0; i <= 200; ++i) {
            diskCache.update((ICacheElement)new CacheElement("testPutGetMatching_SmallWait", (Object)(i + ":key"), (Object)("testPutGetMatching_SmallWait data " + i)));
        }
        Thread.sleep(500L);
        Map matchingResults = diskCache.getMatching("1.8.+");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testPutGetMatching_NoWait() throws Exception {
        int items = 200;
        String cacheName = "testPutGetMatching_NoWait";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testPutGetMatching_NoWait");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (int i = 0; i <= 200; ++i) {
            diskCache.update((ICacheElement)new CacheElement("testPutGetMatching_NoWait", (Object)(i + ":key"), (Object)("testPutGetMatching_NoWait data " + i)));
        }
        Map matchingResults = diskCache.getMatching("1.8.+");
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Wrong number returned", (int)10, (int)matchingResults.size());
    }

    public void testUTF8String() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String cacheName = "testUTF8String";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testUTF8String");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement("testUTF8String", (Object)"x", (Object)string));
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        String after = (String)afterElement.getVal();
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)after);
    }

    public void testUTF8ByteArray() throws Exception {
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 4; ++i) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        String cacheName = "testUTF8ByteArray";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testUTF8ByteArray");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        diskCache.update((ICacheElement)new CacheElement("testUTF8ByteArray", (Object)"x", (Object)bytes));
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)diskCache.get((Object)"x"));
        Thread.sleep(1000L);
        ICacheElement afterElement = diskCache.get((Object)"x");
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)afterElement);
        byte[] after = (byte[])afterElement.getVal();
        IndexDiskCacheUnitTestAbstract.assertNotNull((Object)after);
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong bytes after retrieval", (String)string, (String)new String(after, StandardCharsets.UTF_8));
    }

    public void testProcessUpdate_Simple() throws IOException {
        String cacheName = "testProcessUpdate_Simple";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testProcessUpdate_Simple");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        CacheElement ce = new CacheElement("testProcessUpdate_Simple", (Object)"myKey", (Object)"myValue");
        diskCache.processUpdate((ICacheElement)ce);
        ICacheElement result = diskCache.processGet((Object)"myKey");
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"File should be greater than 0", (fileSize > 0L ? 1 : 0) != 0);
    }

    public void testProcessUpdate_SameKeySameSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeySameSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testProcessUpdate_SameKeySameSize");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        CacheElement ce1 = new CacheElement("testProcessUpdate_SameKeySameSize", (Object)"myKey", (Object)"myValue");
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement("testProcessUpdate_SameKeySameSize", (Object)"myKey", (Object)"myValue");
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)"myKey");
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"File should be the same", (long)fileSize1, (long)fileSize2);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be nothing in the bin.", (int)0, (int)binSize);
    }

    public void testProcessUpdate_SameKeySmallerSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeySmallerSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testProcessUpdate_SameKeySmallerSize");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        String value2 = "myValu";
        CacheElement ce1 = new CacheElement("testProcessUpdate_SameKeySmallerSize", (Object)"myKey", (Object)"myValue");
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement("testProcessUpdate_SameKeySmallerSize", (Object)"myKey", (Object)"myValu");
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)"myKey");
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"File should be the same", (long)fileSize1, (long)fileSize2);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be nothing in the bin.", (int)0, (int)binSize);
    }

    public void testProcessUpdate_SameKeyBiggerSize() throws IOException {
        String cacheName = "testProcessUpdate_SameKeyBiggerSize";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testProcessUpdate_SameKeyBiggerSize");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        String key = "myKey";
        String value = "myValue";
        String value2 = "myValue2";
        CacheElement ce1 = new CacheElement("testProcessUpdate_SameKeyBiggerSize", (Object)"myKey", (Object)"myValue");
        diskCache.processUpdate((ICacheElement)ce1);
        long fileSize1 = diskCache.getDataFileSize();
        CacheElement ce2 = new CacheElement("testProcessUpdate_SameKeyBiggerSize", (Object)"myKey", (Object)"myValue2");
        diskCache.processUpdate((ICacheElement)ce2);
        ICacheElement result = diskCache.processGet((Object)"myKey");
        IndexDiskCacheUnitTestAbstract.assertNotNull((String)"Should have a result", (Object)result);
        long fileSize2 = diskCache.getDataFileSize();
        IndexDiskCacheUnitTestAbstract.assertTrue((String)"File should be greater.", (fileSize1 < fileSize2 ? 1 : 0) != 0);
        int binSize = diskCache.getRecyleBinSize();
        IndexDiskCacheUnitTestAbstract.assertEquals((String)"Should be one in the bin.", (int)1, (int)binSize);
    }

    public void testLoadFromDisk() throws Exception {
        for (int i = 0; i < 15; ++i) {
            this.oneLoadFromDisk();
        }
    }

    public void oneLoadFromDisk() throws Exception {
        int i;
        String string = "I\u00d2t\u00cern\u201ati\u00d9n\u2021liz\u00cati\u00afn";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(sb.toString());
        }
        string = sb.toString();
        String cacheName = "testLoadFromDisk";
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testLoadFromDisk");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/IndexDiskCacheUnitTest");
        IndexedDiskCache diskCache = new IndexedDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            diskCache.update((ICacheElement)new CacheElement("testLoadFromDisk", (Object)("x" + i), (Object)string));
        }
        diskCache.dispose();
        diskCache = new IndexedDiskCache(cattr);
        for (i = 0; i < 50; ++i) {
            ICacheElement afterElement = diskCache.get((Object)("x" + i));
            IndexDiskCacheUnitTestAbstract.assertNotNull((String)("Missing element from cache. Cache size: " + diskCache.getSize() + " element: x" + i), (Object)afterElement);
            IndexDiskCacheUnitTestAbstract.assertEquals((String)"wrong string after retrieval", (String)string, (String)((String)afterElement.getVal()));
        }
    }
}

