/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.GroupCacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;

public class JCSConcurrentCacheAccessUnitTest
extends TestCase {
    private static final int THREADS = 20;
    private static final int LOOPS = 10000;
    protected GroupCacheAccess<Integer, String> cache;
    protected String group = "group";
    protected AtomicInteger errcount;
    protected List<String> valueMismatchList;

    protected void setUp() throws Exception {
        super.setUp();
        JCS.setConfigFilename((String)"/TestJCS-73.ccf");
        this.cache = JCS.getGroupCacheInstance((String)"cache");
        this.errcount = new AtomicInteger(0);
        this.valueMismatchList = new CopyOnWriteArrayList<String>();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cache.clear();
        this.cache.dispose();
    }

    public void testConcurrentAccess() throws Exception {
        int i;
        Worker[] worker = new Worker[20];
        for (i = 0; i < 20; ++i) {
            worker[i] = new Worker();
            worker[i].start();
        }
        for (i = 0; i < 20; ++i) {
            worker[i].join();
        }
        JCSConcurrentCacheAccessUnitTest.assertEquals((String)"Error count should be 0", (int)0, (int)this.errcount.intValue());
        for (String msg : this.valueMismatchList) {
            System.out.println(msg);
        }
        JCSConcurrentCacheAccessUnitTest.assertEquals((String)"Value mismatch count should be 0", (int)0, (int)this.valueMismatchList.size());
    }

    protected class Worker
    extends Thread {
        protected Worker() {
        }

        @Override
        public void run() {
            String name = this.getName();
            for (int idx = 0; idx < 10000; ++idx) {
                if (idx > 0) {
                    String res = (String)JCSConcurrentCacheAccessUnitTest.this.cache.getFromGroup((Object)(idx - 1), JCSConcurrentCacheAccessUnitTest.this.group);
                    if (res == null) {
                        System.out.println("ERROR: for " + idx + " in " + name);
                        JCSConcurrentCacheAccessUnitTest.this.errcount.incrementAndGet();
                        int n = 5;
                        while (n-- > 0) {
                            res = (String)JCSConcurrentCacheAccessUnitTest.this.cache.getFromGroup((Object)(idx - 1), JCSConcurrentCacheAccessUnitTest.this.group);
                            if (res != null) {
                                System.out.println("ERROR FIXED for " + idx + ": " + res + " " + name);
                                JCSConcurrentCacheAccessUnitTest.this.errcount.decrementAndGet();
                                break;
                            }
                            System.out.println("ERROR STILL PERSISTS for " + idx + " in " + name);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!String.valueOf(idx - 1).equals(res)) {
                        JCSConcurrentCacheAccessUnitTest.this.valueMismatchList.add(String.format("Values do not match: %s - %s", String.valueOf(idx - 1), res));
                    }
                }
                try {
                    JCSConcurrentCacheAccessUnitTest.this.cache.putInGroup((Object)idx, JCSConcurrentCacheAccessUnitTest.this.group, (Object)String.valueOf(idx));
                    continue;
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
            }
        }
    }
}

