/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import org.apache.commons.jci.AbstractTestCase;
import org.apache.commons.jci.stores.FileResourceStore;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.lang3.ArrayUtils;

public final class ResourceStoreTestCase
extends AbstractTestCase {
    public void testMemoryResourceStore() {
        this.checkReadWrite((ResourceStore)new MemoryResourceStore());
        this.checkRemove((ResourceStore)new MemoryResourceStore());
    }

    public void testFileResourceStore() {
        this.checkReadWrite((ResourceStore)new FileResourceStore(this.directory));
        this.checkRemove((ResourceStore)new FileResourceStore(this.directory));
    }

    public void testTransactionalFileResourceStore() {
        this.checkReadWrite((ResourceStore)new TransactionalResourceStore((ResourceStore)new FileResourceStore(this.directory)));
        this.checkRemove((ResourceStore)new TransactionalResourceStore((ResourceStore)new FileResourceStore(this.directory)));
        FileResourceStore rs = new FileResourceStore(this.directory);
        TransactionalResourceStore trs = new TransactionalResourceStore((ResourceStore)rs);
        ResourceStoreTestCase.assertEquals((String)rs.toString(), (String)trs.toString());
    }

    private void checkReadWrite(ResourceStore pStore) {
        byte[] data = new byte[]{1, 2, 3};
        pStore.write("key", data);
        byte[] read = pStore.read("key");
        ResourceStoreTestCase.assertTrue((read != null ? 1 : 0) != 0);
        ResourceStoreTestCase.assertTrue((boolean)ArrayUtils.isEquals((Object)data, (Object)read));
    }

    private void checkRemove(ResourceStore pStore) {
        byte[] data = new byte[]{1, 2, 3};
        pStore.write("key", data);
        byte[] read = pStore.read("key");
        ResourceStoreTestCase.assertTrue((read != null ? 1 : 0) != 0);
        ResourceStoreTestCase.assertTrue((boolean)ArrayUtils.isEquals((Object)data, (Object)read));
        pStore.remove("key");
        byte[] empty = pStore.read("key");
        ResourceStoreTestCase.assertTrue((empty == null ? 1 : 0) != 0);
    }
}

