/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.AbstractTest;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.ProgressListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractProgressListenerTest<AFU extends AbstractFileUpload<R, I, F>, R, I extends FileItem<I>, F extends FileItemFactory<I>>
extends AbstractTest<AFU, R, I, F> {
    protected void runTest(int itemCount, long contentLength, R request) throws FileUploadException, IOException {
        Object upload = this.newFileUpload();
        ProgressListenerImpl listener = new ProgressListenerImpl(contentLength, itemCount);
        upload.setProgressListener((ProgressListener)listener);
        FileItemInputIterator iter = upload.getItemIterator(request);
        for (int i = 0; i < itemCount; ++i) {
            int idxI = i;
            FileItemInput fileItemInput = iter.next();
            try (InputStream inputStream = fileItemInput.getInputStream();){
                for (int j = 0; j < 16384 + i; ++j) {
                    int idxJ = j;
                    byte b1 = (byte)j;
                    byte b2 = (byte)inputStream.read();
                    Assertions.assertEquals((byte)b1, (byte)b2, () -> String.format("itemCount = %,d, i = %,d, j = %,d", itemCount, idxI, idxJ));
                }
                Assertions.assertEquals((int)-1, (int)inputStream.read());
                continue;
            }
        }
        Assertions.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        listener.checkFinished();
    }

    @Test
    public void testProgressListener() throws IOException {
        int numItems = 512;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 512; ++i) {
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + (i + 1) + "\"\r\n\r\n";
            baos.write(header.getBytes(StandardCharsets.US_ASCII));
            for (int j = 0; j < 16384 + i; ++j) {
                baos.write((byte)j);
            }
            baos.write("\r\n".getBytes(StandardCharsets.US_ASCII));
        }
        baos.write("-----1234--\r\n".getBytes(StandardCharsets.US_ASCII));
        byte[] requestBytes = baos.toByteArray();
        Object request = this.newMockHttpServletRequest(requestBytes, null, "multipart/form-data; boundary=---1234", null);
        this.runTest(512, requestBytes.length, request);
        request = this.newMockHttpServletRequest(requestBytes, (Long)-1L, "multipart/form-data; boundary=---1234", null);
        this.runTest(512, requestBytes.length, request);
    }

    protected static class ProgressListenerImpl
    implements ProgressListener {
        private final long expectedContentLength;
        private final int expectedItems;
        private Long bytesRead;
        private Integer items;

        ProgressListenerImpl(long contentLength, int itemCount) {
            this.expectedContentLength = contentLength;
            this.expectedItems = itemCount;
        }

        void checkFinished() {
            Assertions.assertEquals((long)this.expectedContentLength, (long)this.bytesRead);
            Assertions.assertEquals((int)this.expectedItems, (int)this.items);
        }

        public void update(long actualBytesRead, long actualContentLength, int actualItems) {
            Assertions.assertTrue((actualBytesRead >= 0L && actualBytesRead <= this.expectedContentLength ? 1 : 0) != 0);
            Assertions.assertTrue((actualContentLength == -1L || actualContentLength == this.expectedContentLength ? 1 : 0) != 0);
            Assertions.assertTrue((actualItems >= 0 && actualItems <= this.expectedItems ? 1 : 0) != 0);
            Assertions.assertTrue((this.bytesRead == null || actualBytesRead >= this.bytesRead ? 1 : 0) != 0);
            this.bytesRead = actualBytesRead;
            Assertions.assertTrue((this.items == null || actualItems >= this.items ? 1 : 0) != 0);
            this.items = actualItems;
        }
    }
}

