/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.junit.Assert;
import org.junit.Test;

public class MultipartStreamTest {
    private static final String BOUNDARY_TEXT = "myboundary";

    @Test
    public void testThreeParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        int iBufSize = boundary.length + MultipartStream.BOUNDARY_PREFIX.length + 1;
        MultipartStream ms = new MultipartStream((InputStream)input, boundary, iBufSize, new MultipartStream.ProgressNotifier(null, (long)contents.length));
        Assert.assertNotNull((Object)ms);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSmallBuffer() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        int iBufSize = 1;
        new MultipartStream((InputStream)input, boundary, iBufSize, new MultipartStream.ProgressNotifier(null, (long)contents.length));
    }

    @Test
    public void testTwoParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        MultipartStream ms = new MultipartStream((InputStream)input, boundary, new MultipartStream.ProgressNotifier(null, (long)contents.length));
        Assert.assertNotNull((Object)ms);
    }
}

