/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.util;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.util.MimeMessageParser;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MimeMessageParserTest {
    @Test
    public void testAttachmentOnly() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (Path)Paths.get("./src/test/resources/eml/attachment-only.eml", new String[0]), (OpenOption[])new OpenOption[0]);
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Kunde 100029   Auftrag   3600", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertFalse((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Kunde 100029   Auftrag   3600.pdf");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"application/pdf", (Object)dataSource.getContentType());
    }

    @Test
    public void testMultipartTextAttachment() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-text-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.txt");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
    }

    @Test
    public void testMultipartTextAttachmentOnly() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-text-attachment-only.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.txt");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseCreatedHtmlEmailWithMixedContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.setTextMsg("My test message");
        email.setHtmlMsg("<p>My HTML message</p>");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseCreatedHtmlEmailWithNoContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseCreatedHtmlEmailWithTextContent() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        HtmlEmail email = new HtmlEmail();
        email.setMailSession(session);
        email.setFrom("test_from@apache.org");
        email.setSubject("Test Subject");
        email.addTo("test_to@apache.org");
        email.setTextMsg("My test message");
        email.buildMimeMessage();
        MimeMessage msg = email.getMimeMessage();
        MimeMessageParser mimeMessageParser = new MimeMessageParser(msg);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test Subject", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseHtmlEmailWithAttachmentAndEncodedFileName() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment-encoded-filename.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test HTML Send #1 Subject (w charset)", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = (DataSource)mimeMessageParser.getAttachmentList().get(0);
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"text/plain", (Object)dataSource.getContentType());
        Assertions.assertEquals((Object)"Test Attachment - a>\u00e4, o>\u00f6, u>\u00fc, au>\u00e4u", (Object)dataSource.getName());
    }

    @Test
    public void testParseHtmlEmailWithAttachments() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)2, (int)attachmentList.size());
        DataSource dataSource = mimeMessageParser.findAttachmentByName("Wasserlilien.jpg");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"image/jpeg", (Object)dataSource.getContentType());
        dataSource = mimeMessageParser.findAttachmentByName("it20one.pdf");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"application/pdf", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseHtmlEmailWithHtmlAttachment() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment-content-disposition.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"test", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = mimeMessageParser.findAttachmentByName("test.html");
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertEquals((Object)"text/html", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseInlineCID() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/html-attachment.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        Assertions.assertTrue((boolean)mimeMessageParser.getContentIds().contains("part1.01080006.06060206@it20one.at"));
        Assertions.assertFalse((boolean)mimeMessageParser.getContentIds().contains("part2"));
        DataSource ds = mimeMessageParser.findAttachmentByCid("part1.01080006.06060206@it20one.at");
        Assertions.assertNotNull((Object)ds);
        Assertions.assertEquals((Object)ds, mimeMessageParser.getAttachmentList().get(0));
    }

    @Test
    public void testParseMultipartReport() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/multipart-report.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Gelesen: ", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertTrue((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"siegfried.goeschl@it20one.at", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertTrue((boolean)mimeMessageParser.hasAttachments());
        List attachmentList = mimeMessageParser.getAttachmentList();
        Assertions.assertEquals((int)1, (int)attachmentList.size());
        DataSource dataSource = (DataSource)attachmentList.get(0);
        Assertions.assertNotNull((Object)dataSource);
        Assertions.assertNull((Object)dataSource.getName());
        Assertions.assertEquals((Object)"message/disposition-notification", (Object)dataSource.getContentType());
    }

    @Test
    public void testParseNoHeaderSeperatorWithOutOfMemory() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/outofmemory-no-header-seperation.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"A corrupt Attachment", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertFalse((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertEquals((int)mimeMessageParser.getCc().size(), (int)0);
        Assertions.assertEquals((int)mimeMessageParser.getBcc().size(), (int)0);
    }

    @Test
    public void testParseSimpleEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Test HTML Send #1 Subject (wo charset)", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertTrue((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"test_from@apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }

    @Test
    public void testParseSimpleReplyEmail() throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage message = MimeMessageUtils.createMimeMessage((Session)session, (File)new File("./src/test/resources/eml/simple-reply.eml"));
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        mimeMessageParser.parse();
        Assertions.assertEquals((Object)"Re: java.lang.NoClassDefFoundError: org/bouncycastle/asn1/pkcs/PrivateKeyInfo", (Object)mimeMessageParser.getSubject());
        Assertions.assertNotNull((Object)mimeMessageParser.getMimeMessage());
        Assertions.assertFalse((boolean)mimeMessageParser.isMultipart());
        Assertions.assertFalse((boolean)mimeMessageParser.hasHtmlContent());
        Assertions.assertTrue((boolean)mimeMessageParser.hasPlainContent());
        Assertions.assertNotNull((Object)mimeMessageParser.getPlainContent());
        Assertions.assertNull((Object)mimeMessageParser.getHtmlContent());
        Assertions.assertEquals((int)1, (int)mimeMessageParser.getTo().size());
        Assertions.assertTrue((boolean)mimeMessageParser.getCc().isEmpty());
        Assertions.assertTrue((boolean)mimeMessageParser.getBcc().isEmpty());
        Assertions.assertEquals((Object)"coheigea@apache.org", (Object)mimeMessageParser.getFrom());
        Assertions.assertEquals((Object)"dev@ws.apache.org", (Object)mimeMessageParser.getReplyTo());
        Assertions.assertFalse((boolean)mimeMessageParser.hasAttachments());
    }
}

