/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import org.apache.commons.mail.EmailUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmailUtilsTest {
    @Test
    public void testClearEndOfLineCharacters() {
        Assertions.assertEquals(null, (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces(null));
        Assertions.assertEquals((Object)"", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)""));
        Assertions.assertEquals((Object)"   ", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"   "));
        Assertions.assertEquals((Object)"abcdefg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abcdefg"));
        Assertions.assertEquals((Object)"abc defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\rdefg"));
        Assertions.assertEquals((Object)"abc defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\ndefg"));
        Assertions.assertEquals((Object)"abc  defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\r\ndefg"));
        Assertions.assertEquals((Object)"abc  defg", (Object)EmailUtils.replaceEndOfLineCharactersWithSpaces((String)"abc\n\rdefg"));
    }

    @Test
    public void testUrlEncoding() {
        Assertions.assertEquals((Object)"abcdefg", (Object)EmailUtils.encodeUrl((String)"abcdefg"));
        Assertions.assertEquals((Object)"0123456789", (Object)EmailUtils.encodeUrl((String)"0123456789"));
        Assertions.assertEquals((Object)"Test%20CID", (Object)EmailUtils.encodeUrl((String)"Test CID"));
        Assertions.assertEquals((Object)"joe.doe@apache.org", (Object)EmailUtils.encodeUrl((String)"joe.doe@apache.org"));
        Assertions.assertEquals((Object)"joe+doe@apache.org", (Object)EmailUtils.encodeUrl((String)"joe+doe@apache.org"));
        Assertions.assertEquals((Object)"peter%26paul%26mary@oldmusic.org", (Object)EmailUtils.encodeUrl((String)"peter&paul&mary@oldmusic.org"));
    }
}

