/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.Iterator;
import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.StringTemplateParser;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.LoopTagStatus;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ForEach
extends Instruction {
    protected static final Iterator NULL_ITER = new Iterator(){

        public boolean hasNext() {
            return true;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };
    private final Subst items;
    private final Subst var;
    private final Subst varStatus;
    private final Subst begin;
    private final Subst end;
    private final Subst step;

    public ForEach(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        String name = raw.getLocalName();
        Locator locator = this.getLocation();
        String items = attrs.getValue("items");
        String select = attrs.getValue("select");
        StringTemplateParser expressionCompiler = parsingContext.getStringTemplateParser();
        this.var = expressionCompiler.compileExpr(attrs.getValue("var"), null, locator);
        this.varStatus = expressionCompiler.compileExpr(attrs.getValue("varStatus"), null, locator);
        this.begin = expressionCompiler.compileInt(attrs.getValue("begin"), name, locator);
        this.end = expressionCompiler.compileInt(attrs.getValue("end"), name, locator);
        this.step = expressionCompiler.compileInt(attrs.getValue("step"), name, locator);
        if (items == null) {
            if (select == null && (this.begin == null || this.end == null)) {
                throw new SAXParseException("forEach: \"select\", \"items\", or both \"begin\" and \"end\" must be specified", locator, null);
            }
        } else if (select != null) {
            throw new SAXParseException("forEach: only one of \"select\" or \"items\" may be specified", locator, null);
        }
        this.items = expressionCompiler.compileExpr(items == null ? select : items, null, locator);
    }

    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        int i;
        int step;
        int end;
        int begin;
        Iterator iter = null;
        String var = null;
        String varStatus = null;
        try {
            iter = this.items != null ? this.items.getIterator(objectModel) : NULL_ITER;
            begin = this.begin == null ? 0 : this.begin.getIntValue(objectModel);
            end = this.end == null ? Integer.MAX_VALUE : this.end.getIntValue(objectModel);
            int n = step = this.step == null ? 1 : this.step.getIntValue(objectModel);
            if (this.var != null) {
                var = this.var.getStringValue(objectModel);
            }
            if (this.varStatus != null) {
                varStatus = this.varStatus.getStringValue(objectModel);
            }
        }
        catch (Exception exc) {
            throw new SAXParseException(exc.getMessage(), this.getLocation(), exc);
        }
        catch (Error err) {
            throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
        }
        objectModel.markLocalContext();
        for (i = 0; i < begin && iter.hasNext(); ++i) {
            iter.next();
        }
        LoopTagStatus status = null;
        if (varStatus != null) {
            status = new LoopTagStatus();
            status.setBegin(begin);
            status.setEnd(end);
            status.setStep(step);
            status.setFirst(true);
            objectModel.put((Object)varStatus, (Object)status);
        }
        int count = 1;
        while (i <= end && iter.hasNext()) {
            objectModel.markLocalContext();
            Object value = iter.next();
            objectModel.put((Object)"contextBean", value);
            if (var != null) {
                objectModel.put((Object)var, value);
            }
            if (status != null) {
                status.setIndex(i);
                status.setCount(count);
                status.setFirst(i == begin);
                status.setCurrent(value);
                status.setLast(i == end || !iter.hasNext());
            }
            Invoker.execute(consumer, objectModel, executionContext, macroContext, namespaces, this.getNext(), this.getEndInstruction());
            int skipCounter = step;
            while (--skipCounter > 0 && iter.hasNext()) {
                iter.next();
            }
            i += step;
            ++count;
            objectModel.cleanupLocalContext();
        }
        objectModel.cleanupLocalContext();
        return this.getEndInstruction().getNext();
    }
}

