/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseConnection
implements ClientConnection {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected long messageId;

    protected BaseConnection() {
    }

    public Object sendMessage(ClientMessage message) throws CayenneRuntimeException {
        Object response;
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        this.beforeSendMessage(message);
        long t0 = 0L;
        String messageLabel = "";
        long messageId = this.messageId++;
        if (this.logger.isInfoEnabled()) {
            t0 = System.currentTimeMillis();
            messageLabel = message.toString();
            this.logger.info((Object)("--- Message " + messageId + ": " + messageLabel));
        }
        try {
            response = this.doSendMessage(message);
        }
        catch (CayenneRuntimeException e) {
            if (this.logger.isInfoEnabled()) {
                long time = System.currentTimeMillis() - t0;
                this.logger.info((Object)("*** Message error for " + messageId + ": " + messageLabel + " - took " + time + " ms."));
            }
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            long time = System.currentTimeMillis() - t0;
            this.logger.info((Object)("=== Message " + messageId + ": " + messageLabel + " done - took " + time + " ms."));
        }
        return response;
    }

    public long getProcessedMessagesCount() {
        return this.messageId + 1L;
    }

    protected abstract void beforeSendMessage(ClientMessage var1) throws CayenneRuntimeException;

    protected abstract Object doSendMessage(ClientMessage var1) throws CayenneRuntimeException;
}

