/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util.convertor;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import org.scopemvc.util.convertor.NullStringConvertor;

public class BigDecimalStringConvertor
extends NullStringConvertor {
    private DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    private boolean convertDot = this.symbols.getDecimalSeparator() == '.';

    public Object stringAsValue(String string) throws IllegalArgumentException {
        if (this.isNull(string)) {
            return null;
        }
        String string2 = this.convertDot ? string.replace(this.symbols.getDecimalSeparator(), '.') : string;
        try {
            BigDecimal bigDecimal = new BigDecimal(string2);
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal value: " + numberFormatException.getMessage());
        }
    }

    public String valueAsString(Object object) throws IllegalArgumentException {
        if (object == null) {
            return this.getNullAsString();
        }
        if (!(object instanceof BigDecimal)) {
            throw new IllegalArgumentException("Passed object is not BigDecimal");
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        return this.convertDot ? bigDecimal.toString().replace('.', this.symbols.getDecimalSeparator()) : bigDecimal.toString();
    }
}

