/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesDialog;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesModel;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.View;

public class SchemaUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "cayenne.modeler.datamap.defaultprefs.schema.radio";
    public static final String UNINIT_CONTROL = "cayenne.modeler.datamap.defaultprefs.schemanull.radio";

    public SchemaUpdateController(ProjectController mediator, DataMap dataMap) {
        super(mediator, dataMap);
    }

    public void startup() {
        DefaultsPreferencesDialog view = new DefaultsPreferencesDialog(ALL_CONTROL, UNINIT_CONTROL);
        view.setTitle("Update DbEntities Schema");
        this.setView((View)view);
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID("cayenne.modeler.datamap.defaultprefs.update.button")) {
            this.updateSchema();
        } else {
            super.doHandleControl(control);
        }
    }

    protected void updateSchema() {
        boolean doAll = ((DefaultsPreferencesModel)this.getModel()).isAllEntities();
        String defaultSchema = this.dataMap.getDefaultSchema();
        for (DbEntity entity : this.dataMap.getDbEntities()) {
            if (!doAll && !Util.isEmptyString((String)entity.getSchema()) || Util.nullSafeEquals((Object)defaultSchema, (Object)entity.getSchema())) continue;
            entity.setSchema(defaultSchema);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)entity));
        }
        for (Procedure procedure : this.dataMap.getProcedures()) {
            if (!doAll && !Util.isEmptyString((String)procedure.getSchema()) || Util.nullSafeEquals((Object)defaultSchema, (Object)procedure.getSchema())) continue;
            procedure.setSchema(defaultSchema);
            this.mediator.fireProcedureEvent(new ProcedureEvent((Object)this, procedure));
        }
        this.shutdown();
    }
}

