/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.nio.charset.Charset;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;

public final class Utf8StringConverter
implements BytesConverter<String> {
    static final String DEFAULT_CHARSET = "UTF-8";
    public static final BytesConverter<String> INSTANCE = new Utf8StringConverter();
    private Charset utf8 = Charset.forName("UTF-8");

    Utf8StringConverter() {
    }

    @Override
    public byte[] toBytes(String value) {
        return value.getBytes(this.utf8);
    }

    @Override
    public String fromBytes(byte[] bytes) {
        return new String(bytes, this.utf8);
    }
}

