/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.LogbookApi;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.core.logbook.DelegatingLogStore;
import org.apache.brooklyn.util.core.logbook.LogBookQueryParams;
import org.apache.brooklyn.util.core.logbook.LogStore;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class LogbookResource
extends AbstractBrooklynRestResource
implements LogbookApi {
    public Response logbookQuery(HttpServletRequest request, LogBookQueryParams params) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.LOGBOOK_LOG_STORE_QUERY, null)) {
            throw WebResourceUtils.unauthorized("User '%s' is not authorized to perform this operation", !Objects.isNull(Entitlements.getEntitlementContext()) ? Entitlements.getEntitlementContext().user() : "");
        }
        Preconditions.checkNotNull((Object)params, (Object)"params must not be null");
        LogStore logStore = new DelegatingLogStore(this.mgmt()).getDelegate();
        try {
            List logs = logStore.query(params);
            return Response.ok((Object)logs, (String)"application/json").build();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

