/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.azureblob.blobstore.functions.BlobMetadataToBlobProperties;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseBlobPropertiesFromHeaders
implements Function<HttpResponse, MutableBlobProperties>,
InvocationContext<ParseBlobPropertiesFromHeaders> {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final BlobMetadataToBlobProperties blobToBlobProperties;
    private String container;

    @Inject
    public ParseBlobPropertiesFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, BlobMetadataToBlobProperties blobToBlobProperties) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToBlobProperties = blobToBlobProperties;
    }

    public MutableBlobProperties apply(HttpResponse from) {
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableBlobProperties to = this.blobToBlobProperties.apply((BlobMetadata)base);
        to.setContainer(this.container);
        String tier = from.getFirstHeaderOrNull("x-ms-access-tier");
        if (tier != null) {
            to.setTier(AccessTier.fromValue(tier));
        }
        return to;
    }

    public ParseBlobPropertiesFromHeaders setContext(HttpRequest request) {
        Preconditions.checkArgument((boolean)(request instanceof GeneratedHttpRequest), (Object)"note this handler requires a GeneratedHttpRequest");
        this.blobMetadataParser.setContext(request);
        return this.setContainer(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getInvocation().getArgs().get(0).toString());
    }

    private ParseBlobPropertiesFromHeaders setContainer(String container) {
        this.container = container;
        return this;
    }
}

