/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.objs.BrooklynType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynTypeSnapshot
implements BrooklynType {
    private static final long serialVersionUID = 4670930188951106009L;
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynTypeSnapshot.class);
    private final String name;
    private volatile transient String simpleName;
    private final Map<String, ConfigKey<?>> configKeys;
    private final Map<String, ConfigKey<?>> configKeysByDeprecatedName;
    private final Set<ConfigKey<?>> configKeysSet;

    protected BrooklynTypeSnapshot(String name, Map<String, ConfigKey<?>> configKeys) {
        this.name = name;
        this.configKeys = ImmutableMap.copyOf(configKeys);
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
        this.configKeysByDeprecatedName = new LinkedHashMap();
        for (ConfigKey<?> key : this.configKeysSet) {
            for (String deprecatedName : key.getDeprecatedNames()) {
                if (configKeys.containsKey(deprecatedName)) {
                    LOG.warn("Conflicting config key name '" + deprecatedName + "' used in " + configKeys.get(deprecatedName) + " and as deprecated name of " + key + "; will prefer " + key + " but may cause problems");
                    continue;
                }
                if (this.configKeysByDeprecatedName.containsKey(deprecatedName)) {
                    LOG.warn("Conflicting config key name '" + deprecatedName + "' used as deprecated name in both " + this.configKeysByDeprecatedName.get(deprecatedName) + " and " + key + "; may cause problems");
                    continue;
                }
                this.configKeysByDeprecatedName.put(deprecatedName, key);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    private String toSimpleName(String name) {
        String simpleName = name.substring(name.lastIndexOf(".") + 1);
        if (Strings.isBlank((CharSequence)simpleName)) {
            simpleName = name.trim();
        }
        return Strings.makeValidFilename((String)simpleName);
    }

    public String getSimpleName() {
        String sn = this.simpleName;
        if (sn == null) {
            this.simpleName = sn = this.toSimpleName(this.getName());
        }
        return sn;
    }

    public Set<ConfigKey<?>> getConfigKeys() {
        return this.configKeysSet;
    }

    public ConfigKey<?> getConfigKey(String name) {
        ConfigKey<?> result = this.configKeys.get(name);
        if (result == null) {
            result = this.configKeysByDeprecatedName.get(name);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.configKeys});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BrooklynTypeSnapshot)) {
            return false;
        }
        BrooklynTypeSnapshot o = (BrooklynTypeSnapshot)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal(this.configKeys, o.configKeys);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((String)this.name).add("configKeys", this.configKeys);
    }
}

