/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.nodejs;

import com.google.common.base.Predicates;
import com.google.common.net.HostAndPort;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.WebAppServiceMethods;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppDriver;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppService;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsWebAppServiceImpl
extends SoftwareProcessImpl
implements NodeJsWebAppService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsWebAppService.class);
    private transient HttpFeed httpFeed;

    public Class<?> getDriverInterface() {
        return NodeJsWebAppDriver.class;
    }

    public NodeJsWebAppDriver getDriver() {
        return (NodeJsWebAppDriver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        ConfigToAttributes.apply((Entity)this);
        HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getHttpPort());
        String nodeJsUrl = String.format("http://%s:%d", accessible.getHost(), accessible.getPort());
        if (this.isHttpMonitoringEnabled()) {
            LOG.info("Connecting to {}", (Object)nodeJsUrl);
            this.httpFeed = HttpFeed.builder().entity((Entity)this).baseUri(nodeJsUrl).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).suppressDuplicates(true)).suburl((String)this.getConfig(NodeJsWebAppService.SERVICE_UP_PATH)).checkSuccess(Predicates.alwaysTrue())).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).setOnException((Object)false)).build();
        } else {
            this.connectServiceUpIsRunning();
        }
        WebAppServiceMethods.connectWebAppServerPolicies(this);
    }

    public void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    protected void postStop() {
        super.postStop();
        this.sensors().set(REQUESTS_PER_SECOND_LAST, (Object)0.0);
        this.sensors().set(REQUESTS_PER_SECOND_IN_WINDOW, (Object)0.0);
    }

    protected boolean isHttpMonitoringEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_HTTP_MONITORING));
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)Attributes.HTTP_PORT);
    }
}

