/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.WeightedRandomSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WeightedRandomSelectionImpl<T>
implements WeightedRandomSelection<T> {
    static final Logger LOG = LoggerFactory.getLogger(WeightedRandomSelectionImpl.class);
    Double randomMax;
    int maxProbabilityMultiplier;
    Map<T, WeightedRandomSelection.WeightedObject> map;
    TreeMap<Double, T> cummulativeMap = new TreeMap();
    ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    WeightedRandomSelectionImpl() {
        this.maxProbabilityMultiplier = -1;
    }

    WeightedRandomSelectionImpl(int maxMultiplier) {
        this.maxProbabilityMultiplier = maxMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMap(Map<T, WeightedRandomSelection.WeightedObject> map) {
        Long totalWeight = 0L;
        Long min = Long.MAX_VALUE;
        ArrayList<WeightedRandomSelection.WeightedObject> values = new ArrayList<WeightedRandomSelection.WeightedObject>(map.values());
        Collections.sort(values, new Comparator<WeightedRandomSelection.WeightedObject>(){

            @Override
            public int compare(WeightedRandomSelection.WeightedObject o1, WeightedRandomSelection.WeightedObject o2) {
                long diff = o1.getWeight() - o2.getWeight();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < values.size(); ++i) {
            totalWeight = totalWeight + ((WeightedRandomSelection.WeightedObject)values.get(i)).getWeight();
            if (((WeightedRandomSelection.WeightedObject)values.get(i)).getWeight() == 0L || min <= ((WeightedRandomSelection.WeightedObject)values.get(i)).getWeight()) continue;
            min = ((WeightedRandomSelection.WeightedObject)values.get(i)).getWeight();
        }
        double median = 0.0;
        if (totalWeight == 0L) {
            min = 1L;
            median = 1.0;
            totalWeight = values.size();
        } else {
            int mid = values.size() / 2;
            median = values.size() % 2 == 1 ? (double)((WeightedRandomSelection.WeightedObject)values.get(mid)).getWeight() : (double)(((WeightedRandomSelection.WeightedObject)values.get(mid - 1)).getWeight() + ((WeightedRandomSelection.WeightedObject)values.get(mid)).getWeight()) / 2.0;
        }
        double medianWeight = median / (double)totalWeight.longValue();
        double minWeight = (double)min.longValue() / (double)totalWeight.longValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating weights map. MediaWeight: {} MinWeight: {}", (Object)medianWeight, (Object)minWeight);
        }
        double maxWeight = (double)this.maxProbabilityMultiplier * medianWeight;
        HashMap<T, Double> weightMap = new HashMap<T, Double>();
        for (Map.Entry<T, WeightedRandomSelection.WeightedObject> e : map.entrySet()) {
            double weightedProbability = e.getValue().getWeight() > 0L ? (double)e.getValue().getWeight() / (double)totalWeight.longValue() : minWeight;
            if (maxWeight > 0.0 && weightedProbability > maxWeight) {
                weightedProbability = maxWeight;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Capping the probability to {} for {} Value: {}", new Object[]{weightedProbability, e.getKey(), e.getValue()});
                }
            }
            weightMap.put(e.getKey(), weightedProbability);
        }
        TreeMap tmpCummulativeMap = new TreeMap();
        Double key = 0.0;
        for (Map.Entry e : weightMap.entrySet()) {
            tmpCummulativeMap.put(key, e.getKey());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key: {} Value: {} AssignedKey: {} AssignedWeight: {}", new Object[]{e.getKey(), e.getValue(), key, e.getValue()});
            }
            key = key + (Double)e.getValue();
        }
        this.rwLock.writeLock().lock();
        try {
            this.map = map;
            this.cummulativeMap = tmpCummulativeMap;
            this.randomMax = key;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getNextRandom() {
        this.rwLock.readLock().lock();
        try {
            Double randomNum = this.randomMax * Math.random();
            Double key = this.cummulativeMap.floorKey(randomNum);
            T t = this.cummulativeMap.get(key);
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void setMaxProbabilityMultiplier(int max) {
        this.maxProbabilityMultiplier = max;
    }

    @Override
    public T getNextRandom(Collection<T> selectedNodes) {
        throw new UnsupportedOperationException("getNextRandom is not implemented for WeightedRandomSelectionImpl");
    }
}

