/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKWatchManager;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveWatchesTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveWatchesTest.class);
    private ZooKeeper zk1 = null;
    private ZooKeeper zk2 = null;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk1 = this.createClient();
        this.zk2 = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.zk1 != null) {
            this.zk1.close();
        }
        if (this.zk2 != null) {
            this.zk2.close();
        }
        super.tearDown();
    }

    private void removeWatches(ZooKeeper zk, String path, Watcher watcher, Watcher.WatcherType watcherType, boolean local, KeeperException.Code rc, boolean useAsync) throws InterruptedException, KeeperException {
        LOG.info("Sending removeWatches req using zk {} path: {} type: {} watcher: {} ", new Object[]{zk, path, watcherType, watcher});
        if (useAsync) {
            MyCallback c1 = new MyCallback(rc.intValue(), path);
            zk.removeWatches(path, watcher, watcherType, local, (AsyncCallback.VoidCallback)c1, null);
            Assertions.assertTrue((boolean)c1.matches(), (String)"Didn't succeeds removeWatch operation");
            if (KeeperException.Code.OK.intValue() != c1.rc) {
                KeeperException ke = KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)c1.rc));
                throw ke;
            }
        } else {
            zk.removeWatches(path, watcher, watcherType, local);
        }
    }

    private void removeAllWatches(ZooKeeper zk, String path, Watcher.WatcherType watcherType, boolean local, KeeperException.Code rc, boolean useAsync) throws InterruptedException, KeeperException {
        LOG.info("Sending removeWatches req using zk {} path: {} type: {} ", new Object[]{zk, path, watcherType});
        if (useAsync) {
            MyCallback c1 = new MyCallback(rc.intValue(), path);
            zk.removeAllWatches(path, watcherType, local, (AsyncCallback.VoidCallback)c1, null);
            Assertions.assertTrue((boolean)c1.matches(), (String)"Didn't succeeds removeWatch operation");
            if (KeeperException.Code.OK.intValue() != c1.rc) {
                KeeperException ke = KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)c1.rc));
                throw ke;
            }
        } else {
            zk.removeAllWatches(path, watcherType, local);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveSingleWatcher(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.zk1.create("/node2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        MyWatcher w2 = new MyWatcher("/node2", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node2", (Watcher)w2), (String)"Didn't set data watches");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        Assertions.assertEquals((int)1, (int)this.zk2.getDataWatches().size(), (String)"Didn't find data watcher");
        Assertions.assertEquals((Object)"/node2", this.zk2.getDataWatches().get(0), (String)"Didn't find data watcher");
        this.removeWatches(this.zk2, "/node2", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove data watcher");
        if (this.zk1 != null) {
            this.zk1.close();
            this.zk1 = null;
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assertions.assertFalse((boolean)events.contains(Watcher.Event.EventType.NodeDeleted), (String)"Shouldn't get NodeDeletedEvent after watch removal");
        Assertions.assertEquals((int)0, (int)events.size(), (String)"Shouldn't get NodeDeletedEvent after watch removal");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testMultipleDataWatchers(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w2), (String)"Didn't set data watches");
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        Assertions.assertEquals((int)1, (int)this.zk2.getDataWatches().size(), (String)"Didn't find data watcher");
        Assertions.assertEquals((Object)"/node1", this.zk2.getDataWatches().get(0), (String)"Didn't find data watcher");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove data watcher");
        if (this.zk1 != null) {
            this.zk1.close();
            this.zk1 = null;
        }
        List<Watcher.Event.EventType> events = w2.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)0, (int)events.size(), (String)"Shouldn't get NodeDeletedEvent after watch removal");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testMultipleChildWatchers(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getChildWatches().size(), (String)"Didn't find child watcher");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove child watcher");
        this.zk1.create("/node1/node2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int count = 30; count > 0 && w1.getEventsAfterWatchRemoval().size() <= 0; --count) {
            Thread.sleep(100L);
        }
        List<Watcher.Event.EventType> events = w2.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)0, (int)events.size(), (String)"Shouldn't get NodeChildrenChanged event");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllWatchers(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w2), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        this.zk1.create("/node1/child", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove data watcher");
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllDataWatchers(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w2), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        this.zk1.create("/node1/child", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove data watcher");
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove data watcher");
        for (int count = 10; count > 0 && (w1.getEventsAfterWatchRemoval().size() <= 0 || w2.getEventsAfterWatchRemoval().size() <= 0); --count) {
            Thread.sleep(1000L);
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Didn't get NodeChildrenChanged event");
        Assertions.assertTrue((boolean)events.contains(Watcher.Event.EventType.NodeChildrenChanged), (String)"Didn't get NodeChildrenChanged event");
        events = w2.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Didn't get NodeChildrenChanged event");
        Assertions.assertTrue((boolean)events.contains(Watcher.Event.EventType.NodeChildrenChanged), (String)"Didn't get NodeChildrenChanged event");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllChildWatchers(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w2), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
        this.zk1.setData("/node1", "test".getBytes(), -1);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove child watcher");
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
        for (int count = 10; count > 0 && (w1.getEventsAfterWatchRemoval().size() <= 0 || w2.getEventsAfterWatchRemoval().size() <= 0); --count) {
            Thread.sleep(1000L);
        }
        List<Watcher.Event.EventType> events = w1.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Didn't get NodeDataChanged event");
        Assertions.assertTrue((boolean)events.contains(Watcher.Event.EventType.NodeDataChanged), (String)"Didn't get NodeDataChanged event");
        events = w2.getEventsAfterWatchRemoval();
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Didn't get NodeDataChanged event");
        Assertions.assertTrue((boolean)events.contains(Watcher.Event.EventType.NodeDataChanged), (String)"Didn't get NodeDataChanged event");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testNoWatcherException(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNull((Object)this.zk2.exists("/node2", (Watcher)w2), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        MyWatcher w3 = new MyWatcher("/node1", 2);
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Any, false, KeeperException.Code.NOWATCHER, useAsync);
            Assertions.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Children, false, KeeperException.Code.NOWATCHER, useAsync);
            Assertions.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/node1", w3, Watcher.WatcherType.Data, false, KeeperException.Code.NOWATCHER, useAsync);
            Assertions.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
        try {
            this.removeWatches(this.zk2, "/nonexists", w3, Watcher.WatcherType.Data, false, KeeperException.Code.NOWATCHER, useAsync);
            Assertions.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAnyDataWatcher(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 1);
        MyWatcher w2 = new MyWatcher("/node1", 2);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w2), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove data watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getChildWatches().size(), (String)"Didn't find child watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getDataWatches().size(), (String)"Didn't find data watcher");
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAnyChildWatcher(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getChildWatches().size(), (String)"Didn't find child watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getDataWatches().size(), (String)"Didn't find data watcher");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove watchers");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveWatcherWhenNoConnection(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        this.stopServer();
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, true, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
        Assertions.assertFalse((boolean)w1.matches(), (String)"Shouldn't remove data watcher");
        try {
            this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.CONNECTIONLOSS, useAsync);
            Assertions.fail((String)"Should throw exception as last watch removal requires server connection");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)w1.matches(), (String)"Shouldn't remove data watcher");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, true, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove data watcher");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testManyPreNodeWatchers(boolean useAsync) throws Exception {
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            String nodePath = path + i;
            MyWatcher w = new MyWatcher(nodePath, 1);
            wList.add(w);
            LOG.info("Adding pre node watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.exists(nodePath, (Watcher)w);
        }
        Assertions.assertEquals((int)count, (int)this.zk1.getExistWatches().size(), (String)"Failed to add watchers!");
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
            Assertions.assertTrue((boolean)watcher.matches(), (String)"Didn't remove data watcher");
        }
        Assertions.assertEquals((int)0, (int)this.zk1.getExistWatches().size(), (String)"Didn't remove watch references!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testManyChildWatchers(boolean useAsync) throws Exception {
        String nodePath;
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            this.zk1.create(nodePath, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            nodePath = nodePath + "/";
        }
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            MyWatcher w = new MyWatcher(path + i, 1);
            wList.add(w);
            LOG.info("Adding child watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getChildren(nodePath, (Watcher)w);
            nodePath = nodePath + "/";
        }
        Assertions.assertEquals((int)count, (int)this.zk1.getChildWatches().size(), (String)"Failed to add watchers!");
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
            Assertions.assertTrue((boolean)watcher.matches(), (String)"Didn't remove child watcher");
        }
        Assertions.assertEquals((int)0, (int)this.zk1.getChildWatches().size(), (String)"Didn't remove watch references!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testManyDataWatchers(boolean useAsync) throws Exception {
        int i;
        int count = 50;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            String nodePath = path + i;
            MyWatcher w = new MyWatcher(path + i, 1);
            wList.add(w);
            this.zk1.create(nodePath, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Adding data watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getData(nodePath, (Watcher)w, null);
            nodePath = nodePath + "/";
        }
        Assertions.assertEquals((int)count, (int)this.zk1.getDataWatches().size(), (String)"Failed to add watchers!");
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
            Assertions.assertTrue((boolean)watcher.matches(), (String)"Didn't remove data watcher");
        }
        Assertions.assertEquals((int)0, (int)this.zk1.getDataWatches().size(), (String)"Didn't remove watch references!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testManyWatchersWhenNoConnection(boolean useAsync) throws Exception {
        MyWatcher w;
        String nodePath;
        int i;
        int count = 3;
        ArrayList<MyWatcher> wList = new ArrayList<MyWatcher>(count);
        String path = "/node";
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            this.zk1.create(nodePath, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            nodePath = nodePath + "/";
        }
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            w = new MyWatcher(path + i, 2);
            wList.add(w);
            LOG.info("Adding child watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getChildren(nodePath, (Watcher)w);
            nodePath = nodePath + "/";
        }
        Assertions.assertEquals((int)count, (int)this.zk1.getChildWatches().size(), (String)"Failed to add watchers!");
        for (i = 0; i < count; ++i) {
            nodePath = path + i;
            w = (MyWatcher)wList.get(i);
            LOG.info("Adding data watcher {} on path {}", (Object)w, (Object)nodePath);
            this.zk1.getData(nodePath, (Watcher)w, null);
            nodePath = nodePath + "/";
        }
        Assertions.assertEquals((int)count, (int)this.zk1.getDataWatches().size(), (String)"Failed to add watchers!");
        this.stopServer();
        for (i = 0; i < count; ++i) {
            MyWatcher watcher = (MyWatcher)wList.get(i);
            this.removeWatches(this.zk1, path + i, watcher, Watcher.WatcherType.Any, true, KeeperException.Code.OK, useAsync);
            Assertions.assertTrue((boolean)watcher.matches(), (String)"Didn't remove watcher");
        }
        Assertions.assertEquals((int)0, (int)this.zk1.getChildWatches().size(), (String)"Didn't remove watch references!");
        Assertions.assertEquals((int)0, (int)this.zk1.getDataWatches().size(), (String)"Didn't remove watch references!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testChRootRemoveWatcher(boolean useAsync) throws Exception {
        String chRoot = "/appsX";
        this.zk1.create("/appsX", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (this.zk1 != null) {
            this.zk1.close();
        }
        if (this.zk2 != null) {
            this.zk2.close();
        }
        this.zk1 = this.createClient(this.hostPort + chRoot);
        this.zk2 = this.createClient(this.hostPort + chRoot);
        LOG.info("Creating child znode /node1 using chRoot client");
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        MyWatcher w1 = new MyWatcher("/node1", 2);
        MyWatcher w2 = new MyWatcher("/node1", 1);
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", (Watcher)w1), (String)"Didn't set data watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w2);
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        this.zk2.getChildren("/node1", (Watcher)w1);
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w1.matches(), (String)"Didn't remove child watcher");
        Assertions.assertEquals((int)1, (int)this.zk2.getChildWatches().size(), (String)"Didn't find child watcher");
        this.removeWatches(this.zk2, "/node1", w2, Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)w2.matches(), (String)"Didn't remove child watcher");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testNoWatcherServerException(boolean useAsync) throws InterruptedException, IOException, TimeoutException {
        boolean nw;
        MyWatchManager watchManager;
        block2: {
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            ZooKeeper zk = (ZooKeeper)Mockito.spy((Object)new ZooKeeper(this.hostPort, CONNECTION_TIMEOUT, (Watcher)watcher));
            watchManager = new MyWatchManager(false, watcher);
            ((ZooKeeper)Mockito.doReturn((Object)((Object)watchManager)).when((Object)zk)).getWatchManager();
            nw = false;
            watcher.waitForConnected(CONNECTION_TIMEOUT);
            try {
                zk.removeWatches("/nowatchhere", (Watcher)watcher, Watcher.WatcherType.Data, false);
            }
            catch (KeeperException nwe) {
                if (nwe.code().intValue() != KeeperException.Code.NOWATCHER.intValue()) break block2;
                nw = true;
            }
        }
        MatcherAssert.assertThat((String)"Server didn't return NOWATCHER", (Object)watchManager.lastReturnCode, (Matcher)CoreMatchers.is((Object)KeeperException.Code.NOWATCHER.intValue()));
        MatcherAssert.assertThat((String)"NoWatcherException didn't happen", (Object)nw, (Matcher)CoreMatchers.is((Object)true));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllNoWatcherException(boolean useAsync) throws IOException, InterruptedException, KeeperException {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Any, false, KeeperException.Code.NOWATCHER, useAsync);
            Assertions.fail((String)"Should throw exception as given watcher doesn't exists");
        }
        catch (KeeperException.NoWatcherException noWatcherException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=30L)
    public void testNullWatcherReference(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            if (useAsync) {
                this.zk1.removeWatches("/node1", null, Watcher.WatcherType.Data, false, null, null);
            } else {
                this.zk1.removeWatches("/node1", null, Watcher.WatcherType.Data, false);
            }
            Assertions.fail((String)"Must throw IllegalArgumentException as watcher is null!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveWhenMultipleDataWatchesOnAPath(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch dataWatchCount = new CountDownLatch(1);
        CountDownLatch rmWatchCount = new CountDownLatch(1);
        Watcher w1 = event -> {
            if (event.getType() == Watcher.Event.EventType.DataWatchRemoved) {
                rmWatchCount.countDown();
            }
        };
        Watcher w2 = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                dataWatchCount.countDown();
            }
        };
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w2), (String)"Didn't set data watches");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't remove data watcher");
        this.zk1.setData("/node1", "test".getBytes(), -1);
        LOG.info("Waiting for data watchers to be notified");
        Assertions.assertTrue((boolean)dataWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't get data watch notification!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveWhenMultipleChildWatchesOnAPath(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch childWatchCount = new CountDownLatch(1);
        CountDownLatch rmWatchCount = new CountDownLatch(1);
        Watcher w1 = event -> {
            if (event.getType() == Watcher.Event.EventType.ChildWatchRemoved) {
                rmWatchCount.countDown();
            }
        };
        Watcher w2 = event -> {
            if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                childWatchCount.countDown();
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w1).size(), (String)"Didn't set child watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w2).size(), (String)"Didn't set child watches");
        this.removeWatches(this.zk2, "/node1", w1, Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't remove child watcher");
        this.zk1.create("/node1/node2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Waiting for child watchers to be notified");
        Assertions.assertTrue((boolean)childWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't get child watch notification!");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllDataWatchesOnAPath(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch dWatchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(2);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeDataChanged: {
                    dWatchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeDataChanged: {
                    dWatchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w2), (String)"Didn't set data watches");
        Assertions.assertTrue((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data), (String)"Server session is not a watcher");
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Data, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't remove data watcher");
        Assertions.assertFalse((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data), (String)"Server session is still a watcher after removal");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllChildWatchesOnAPath(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch cWatchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(2);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: {
                    cWatchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: {
                    cWatchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w1).size(), (String)"Didn't set child watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w2).size(), (String)"Didn't set child watches");
        Assertions.assertTrue((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Children), (String)"Server session is not a watcher");
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Children, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't remove child watcher");
        Assertions.assertFalse((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Children), (String)"Server session is still a watcher after removal");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testRemoveAllWatchesOnAPath(boolean useAsync) throws Exception {
        this.zk1.create("/node1", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        CountDownLatch watchCount = new CountDownLatch(2);
        CountDownLatch rmWatchCount = new CountDownLatch(4);
        Watcher w1 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: 
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: 
                case NodeDataChanged: {
                    watchCount.countDown();
                    break;
                }
            }
        };
        Watcher w2 = event -> {
            switch (event.getType()) {
                case ChildWatchRemoved: 
                case DataWatchRemoved: {
                    rmWatchCount.countDown();
                    break;
                }
                case NodeChildrenChanged: 
                case NodeDataChanged: {
                    watchCount.countDown();
                    break;
                }
            }
        };
        LOG.info("Adding child watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w1).size(), (String)"Didn't set child watches");
        LOG.info("Adding child watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertEquals((int)0, (int)this.zk2.getChildren("/node1", w2).size(), (String)"Didn't set child watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w1, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w1), (String)"Didn't set data watches");
        LOG.info("Adding data watcher {} on path {}", (Object)w2, (Object)"/node1");
        Assertions.assertNotNull((Object)this.zk2.exists("/node1", w2), (String)"Didn't set data watches");
        Assertions.assertTrue((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data), (String)"Server session is not a watcher");
        this.removeAllWatches(this.zk2, "/node1", Watcher.WatcherType.Any, false, KeeperException.Code.OK, useAsync);
        Assertions.assertTrue((boolean)rmWatchCount.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS), (String)"Didn't remove data watcher");
        Assertions.assertFalse((boolean)this.isServerSessionWatcher(this.zk2.getSessionId(), "/node1", Watcher.WatcherType.Data), (String)"Server session is still a watcher after removal");
        Assertions.assertEquals((long)2L, (long)watchCount.getCount(), (String)"Received watch notification after removal!");
    }

    private boolean isServerSessionWatcher(long sessionId, String path, Watcher.WatcherType type) {
        HashSet cnxns = new HashSet();
        CollectionUtils.addAll(cnxns, this.serverFactory.getConnections().iterator());
        for (ServerCnxn cnxn : cnxns) {
            if (cnxn.getSessionId() != sessionId) continue;
            return this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree().containsWatcher(path, type, (Watcher)cnxn);
        }
        return false;
    }

    private class MyCallback
    implements AsyncCallback.VoidCallback {
        private final String path;
        private final int rc;
        private String eventPath;
        int eventRc;
        private CountDownLatch latch = new CountDownLatch(1);

        public MyCallback(int rc, String path) {
            this.rc = rc;
            this.path = path;
        }

        public void processResult(int rc, String eventPath, Object ctx) {
            System.out.println("latch:" + this.path + " " + eventPath);
            this.eventPath = eventPath;
            this.eventRc = rc;
            this.latch.countDown();
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 5, TimeUnit.MILLISECONDS)) {
                return false;
            }
            return this.path.equals(this.eventPath) && this.rc == this.eventRc;
        }
    }

    private static class MyWatcher
    implements Watcher {
        private final String path;
        private String eventPath;
        private CountDownLatch latch;
        private List<Watcher.Event.EventType> eventsAfterWatchRemoval = new ArrayList<Watcher.Event.EventType>();

        MyWatcher(String path, int count) {
            this.path = path;
            this.latch = new CountDownLatch(count);
        }

        public void process(WatchedEvent event) {
            LOG.debug("Event path : {}, eventPath : {}", (Object)this.path, (Object)event.getPath());
            this.eventPath = event.getPath();
            if (this.latch.getCount() == 0L && event.getType() != Watcher.Event.EventType.None) {
                this.eventsAfterWatchRemoval.add(event.getType());
            }
            if (event.getType() == Watcher.Event.EventType.ChildWatchRemoved || event.getType() == Watcher.Event.EventType.DataWatchRemoved) {
                this.latch.countDown();
            }
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 5, TimeUnit.MILLISECONDS)) {
                LOG.error("Failed waiting to remove the watches");
                return false;
            }
            LOG.debug("Client path : {} eventPath : {}", (Object)this.path, (Object)this.eventPath);
            return this.path.equals(this.eventPath);
        }

        public List<Watcher.Event.EventType> getEventsAfterWatchRemoval() {
            return this.eventsAfterWatchRemoval;
        }
    }

    private static class MyWatchManager
    extends ZKWatchManager {
        int lastReturnCode;

        MyWatchManager(boolean disableAutoWatchReset, Watcher defaultWatcher) {
            super(disableAutoWatchReset, defaultWatcher);
        }

        void containsWatcher(String path, Watcher watcher, Watcher.WatcherType watcherType) {
        }

        protected boolean removeWatches(Map<String, Set<Watcher>> pathVsWatcher, Watcher watcher, String path, boolean local, int rc, Set<Watcher> removedWatchers) {
            this.lastReturnCode = rc;
            return false;
        }
    }
}

