/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class GetCommand
extends ClientCommand<Flags> {
    private static final String NAME = "get";
    private static final String DESC = "Get key/value pair from a table";

    public GetCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table> <key>").build());
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected void run(StorageClient client, Flags flags) throws Exception {
        Preconditions.checkArgument((flags.arguments.size() >= 2 ? 1 : 0) != 0, (Object)"table and key are not provided");
        String tableName = (String)flags.arguments.get(0);
        String key = (String)flags.arguments.get(1);
        try (Table table = (Table)FutureUtils.result((CompletableFuture)client.openTable(tableName));){
            long lastVersion = -1L;
            do {
                try (KeyValue kv = (KeyValue)FutureUtils.result((CompletableFuture)table.getKv((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8))));){
                    if (null == kv) {
                        this.spec.console().println("key '" + key + "' doesn't exist.");
                    } else if (kv.version() > lastVersion) {
                        if (kv.isNumber()) {
                            this.spec.console().println("value = " + kv.numberValue());
                        } else {
                            this.spec.console().println("value = " + new String(ByteBufUtil.getBytes((ByteBuf)((ByteBuf)kv.value())), StandardCharsets.UTF_8));
                        }
                        lastVersion = kv.version();
                    }
                }
                if (!flags.watch) continue;
                Thread.sleep(1000L);
            } while (flags.watch);
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-w", "--watch"}, description="watch the value changes of a key")
        private boolean watch = false;
    }
}

