<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Ballista Scheduler

## Web User Interface

The scheduler provides a web user interface that allows queries to be monitored. Details on how to start the ui is present [here](https://github.com/apache/arrow-ballista/tree/main/ballista/scheduler/ui)

![Ballista Scheduler Web UI](./images/ballista-web-ui.png)

## REST API

The scheduler also provides a REST API that allows jobs to be monitored.

| API                   | Method | Description                                                 |
| --------------------- | ------ | ----------------------------------------------------------- |
| /api/jobs             | GET    | Get a list of jobs that have been submitted to the cluster. |
| /api/job/{job_id}     | GET    | Get a summary of a submitted job.                           |
| /api/job/{job_id}/dot | GET    | Produce a query plan in DOT (graphviz) format.              |
| /api/job/{job_id}     | PATCH  | Cancel a currently running job                              |
| /api/metrics          | GET    | Return current scheduler metric set                         |
