/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.cache.factory;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.cache.CacheException;
import org.apache.archiva.redback.components.cache.CacheHints;
import org.apache.archiva.redback.components.cache.factory.CacheCreator;
import org.apache.archiva.redback.components.cache.impl.NoCacheCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory {
    private static Map caches;
    private static CacheCreator creator;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private CacheFactory() {
        caches = new HashMap();
        try {
            Enumeration<URL> cachePropResources;
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if ((cachePropResources = classLoader.getResources("META-INF/plexus-cache.properties")).hasMoreElements()) {
                URL propURL = cachePropResources.nextElement();
                Properties props = new Properties();
                props.load(propURL.openStream());
                String creatorImpl = props.getProperty("cache.creator");
                Class<?> creatorClass = classLoader.loadClass(creatorImpl);
                creator = (CacheCreator)creatorClass.newInstance();
            }
            if (cachePropResources.hasMoreElements()) {
                this.logger.error("More than 1 CacheCreator provider exists in classpath. Using first one found [{}].", (Object)creator.getClass().getName());
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (InstantiationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static CacheFactory getInstance() {
        return CacheFactoryHolder.instance;
    }

    public void setCacheCreatorFactory(CacheCreator creator) {
        CacheFactory.creator = creator;
    }

    public Cache getCache(String id, CacheHints hints) throws CacheException {
        if (creator == null) {
            return new NoCacheCache();
        }
        if (caches.containsKey(id)) {
            return (Cache)caches.get(id);
        }
        if (hints == null) {
            hints = new CacheHints();
            hints.setName(id);
        }
        Cache cache = creator.createCache(hints);
        caches.put(id, cache);
        return cache;
    }

    static class CacheFactoryHolder {
        static CacheFactory instance = new CacheFactory();

        CacheFactoryHolder() {
        }
    }
}

