/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.cache.builder;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.cache.builder.CacheBuilder;
import org.apache.archiva.redback.components.cache.impl.NoCacheCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DefaultCacheBuilder<V, T>
implements CacheBuilder<V, T> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Cache<V, T> defaultCache;
    private Cache<V, T> noCache = new NoCacheCache();
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initialize() {
        if (this.applicationContext.containsBean("cache#default")) {
            this.defaultCache = (Cache)this.applicationContext.getBean("cache#default", Cache.class);
        } else {
            this.log.info("Cache with role-hint default doesn't exists, default will be no cache");
            this.defaultCache = new NoCacheCache();
        }
    }

    @Override
    public Cache<V, T> getCache(String roleHint) {
        if (this.applicationContext.containsBean("cache#" + roleHint)) {
            return (Cache)this.applicationContext.getBean("cache#" + roleHint, Cache.class);
        }
        return this.getDefaultCache();
    }

    @Override
    public Cache<V, T> getCache(Class clazz) {
        return this.getCache(clazz.getName());
    }

    @PreDestroy
    public void dispose() {
    }

    public Cache<V, T> getDefaultCache() {
        return this.defaultCache == null ? this.noCache : this.defaultCache;
    }
}

