/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.cache;

import org.apache.archiva.redback.components.cache.CacheStatistics;

public abstract class AbstractCacheStatistics
implements CacheStatistics {
    private long cacheHits = 0L;
    private long cacheMiss = 0L;

    @Override
    public long getCacheHits() {
        return this.cacheHits;
    }

    @Override
    public long getCacheMiss() {
        return this.cacheMiss;
    }

    @Override
    public double getCacheHitRate() {
        return this.cacheHits == 0L && this.cacheMiss == 0L ? 0.0 : (double)this.cacheHits / (double)(this.cacheHits + this.cacheMiss);
    }

    @Override
    public abstract long getSize();

    public void hit() {
        ++this.cacheHits;
    }

    public void miss() {
        ++this.cacheMiss;
    }

    @Override
    public void clear() {
        this.cacheHits = 0L;
        this.cacheMiss = 0L;
    }

    @Override
    public long getInMemorySize() {
        return 0L;
    }
}

