/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static String formatWithAge(Date date, String suffix) {
        return DateUtils.formatWithAge(date, "EEE, d MMM yyyy HH:mm:ss Z", suffix);
    }

    public static String formatWithAge(Date date, String dateFormat, String suffix) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        StringBuilder out = new StringBuilder();
        out.append(format.format(date));
        out.append(" - ");
        Calendar now = Calendar.getInstance();
        Calendar then = Calendar.getInstance();
        then.setTime(date);
        long diffMillis = now.getTimeInMillis() - then.getTimeInMillis();
        long days = diffMillis / 86400000L;
        long hours = diffMillis / 3600000L;
        long minutes = diffMillis / 60000L;
        long seconds = diffMillis / 1000L;
        if (days > 0L) {
            out.append(String.valueOf(days)).append(" day");
            if (days > 1L) {
                out.append('s');
            }
        } else if (hours > 0L) {
            out.append(String.valueOf(hours)).append(" hour");
            if (hours > 1L) {
                out.append('s');
            }
        } else if (minutes > 0L) {
            out.append(String.valueOf(minutes)).append(" minute");
            if (minutes > 1L) {
                out.append('s');
            }
        } else if (seconds > 0L) {
            out.append(String.valueOf(seconds)).append(" second");
            if (seconds > 1L) {
                out.append('s');
            }
        }
        out.append(' ').append(suffix);
        return out.toString();
    }
}

