/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.util;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.KeyNotFoundException;
import org.apache.archiva.redback.policy.CookieSettings;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="autoLoginCookies")
public class AutoLoginCookies {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SecuritySystem securitySystem;
    private static final String REMEMBER_ME_KEY = "rbkRememberMe";
    private static final String SIGNON_KEY = "rbkSignon";

    public AuthenticationKey getRememberMeKey(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (!this.isRememberMeEnabled()) {
            return null;
        }
        Cookie rememberMeCookie = AutoLoginCookies.getCookie(httpServletRequest, REMEMBER_ME_KEY);
        if (rememberMeCookie == null) {
            this.log.debug("Remember Me Cookie Not Found: {}", (Object)REMEMBER_ME_KEY);
            return null;
        }
        String providedKey = rememberMeCookie.getValue();
        this.log.debug("Found remember me cookie : {}", (Object)providedKey);
        CookieSettings settings = this.securitySystem.getPolicy().getRememberMeCookieSettings();
        return this.findAuthKey(REMEMBER_ME_KEY, providedKey, settings.getDomain(), settings.getPath(), httpServletResponse, httpServletRequest);
    }

    public void setRememberMeCookie(String principal, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (!this.isRememberMeEnabled()) {
            return;
        }
        try {
            CookieSettings settings = this.securitySystem.getPolicy().getRememberMeCookieSettings();
            int timeout = settings.getCookieTimeout();
            KeyManager keyManager = this.securitySystem.getKeyManager();
            AuthenticationKey authkey = keyManager.createKey(principal, "Remember Me Key", timeout);
            Cookie cookie = AutoLoginCookies.createCookie(REMEMBER_ME_KEY, authkey.getKey(), settings.getDomain(), settings.getPath(), httpServletRequest);
            if (timeout > 0) {
                cookie.setMaxAge(timeout);
            }
            httpServletResponse.addCookie(cookie);
        }
        catch (KeyManagerException e) {
            this.log.warn("Unable to set remember me cookie.");
        }
    }

    public void removeRememberMeCookie(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        CookieSettings settings = this.securitySystem.getPolicy().getRememberMeCookieSettings();
        AutoLoginCookies.removeCookie(httpServletResponse, httpServletRequest, REMEMBER_ME_KEY, settings.getDomain(), settings.getPath());
    }

    public AuthenticationKey getSignonKey(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        Cookie ssoCookie = AutoLoginCookies.getCookie(httpServletRequest, SIGNON_KEY);
        if (ssoCookie == null) {
            this.log.debug("Single Sign On Cookie Not Found: {}", (Object)SIGNON_KEY);
            return null;
        }
        String providedKey = ssoCookie.getValue();
        this.log.debug("Found sso cookie : {}", (Object)providedKey);
        CookieSettings settings = this.securitySystem.getPolicy().getSignonCookieSettings();
        return this.findAuthKey(SIGNON_KEY, providedKey, settings.getDomain(), settings.getPath(), httpServletResponse, httpServletRequest);
    }

    public void setSignonCookie(String principal, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        try {
            CookieSettings settings = this.securitySystem.getPolicy().getSignonCookieSettings();
            int timeout = settings.getCookieTimeout();
            KeyManager keyManager = this.securitySystem.getKeyManager();
            AuthenticationKey authkey = keyManager.createKey(principal, "Signon Session Key", timeout);
            Cookie cookie = AutoLoginCookies.createCookie(SIGNON_KEY, authkey.getKey(), settings.getDomain(), settings.getPath(), httpServletRequest);
            if (timeout > 0) {
                cookie.setMaxAge(timeout);
            }
            httpServletResponse.addCookie(cookie);
        }
        catch (KeyManagerException e) {
            this.log.warn("Unable to set single sign on cookie.");
        }
    }

    public void removeSignonCookie(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        CookieSettings settings = this.securitySystem.getPolicy().getSignonCookieSettings();
        AutoLoginCookies.removeCookie(httpServletResponse, httpServletRequest, SIGNON_KEY, settings.getDomain(), settings.getPath());
    }

    private static String getWebappContext(HttpServletRequest httpRequest) {
        String webappContext = httpRequest.getContextPath();
        if (StringUtils.isEmpty((String)webappContext)) {
            webappContext = "/";
        }
        return webappContext;
    }

    public boolean isRememberMeEnabled() {
        return this.securitySystem.getPolicy().getRememberMeCookieSettings().isEnabled();
    }

    private AuthenticationKey findAuthKey(String cookieName, String providedKey, String domain, String path, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        try {
            AuthenticationKey authkey = this.securitySystem.getKeyManager().findKey(providedKey);
            this.log.debug("Found AuthKey: {}", (Object)authkey);
            return authkey;
        }
        catch (KeyNotFoundException e) {
            this.log.info("Invalid AuthenticationKey {} submitted. Invalidating cookie.", (Object)providedKey);
            AutoLoginCookies.removeCookie(httpServletResponse, httpServletRequest, cookieName, domain, path);
        }
        catch (KeyManagerException e) {
            this.log.error("KeyManagerException: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie cookie = null;
        if (cookies != null && !StringUtils.isEmpty((String)name)) {
            for (int i = 0; i < cookies.length && cookie == null; ++i) {
                if (!StringUtils.equals((String)name, (String)cookies[i].getName())) continue;
                cookie = cookies[i];
            }
        }
        return cookie;
    }

    private static void removeCookie(HttpServletResponse response, HttpServletRequest httpRequest, String cookieName, String domain, String path) {
        Cookie cookie = AutoLoginCookies.createCookie(cookieName, "", domain, path, httpRequest);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    private static Cookie createCookie(String cookieName, String value, String domain, String path, HttpServletRequest httpRequest) {
        Cookie cookie = new Cookie(cookieName, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        } else {
            cookie.setPath(AutoLoginCookies.getWebappContext(httpRequest));
        }
        return cookie;
    }
}

