/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.mail;

import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.integration.mail.MailGenerator;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mailGenerator#velocity")
public class VelocityMailGenerator
implements MailGenerator {
    private Logger log = LoggerFactory.getLogger(VelocityMailGenerator.class);
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    @Named(value="velocityEngine#redback")
    private VelocityEngine velocityEngine;

    @Override
    public String generateMail(String templateName, AuthenticationKey authkey, String baseUrl) {
        VelocityContext context = this.createVelocityContext(authkey, baseUrl);
        String packageName = this.getClass().getPackage().getName().replace('.', '/');
        String templateFile = packageName + "/template/" + templateName + ".vm";
        StringWriter writer = new StringWriter();
        try {
            this.velocityEngine.mergeTemplate(templateFile, (Context)context, (Writer)writer);
        }
        catch (ResourceNotFoundException e) {
            this.log.error("No such template: '{}'.", (Object)templateFile);
        }
        catch (ParseErrorException e) {
            this.log.error("Unable to generate email for template '{}': {}", new Object[]{templateFile, e.getMessage(), e});
        }
        catch (MethodInvocationException e) {
            this.log.error("Unable to generate email for template '{}': {}", new Object[]{templateFile, e.getMessage(), e});
        }
        catch (Exception e) {
            this.log.error("Unable to generate email for template '{}': {}", new Object[]{templateFile, e.getMessage(), e});
        }
        return writer.getBuffer().toString();
    }

    private VelocityContext createVelocityContext(AuthenticationKey authkey, String appUrl) {
        VelocityContext context = new VelocityContext();
        context.put("applicationUrl", (Object)this.config.getString("application.url", appUrl));
        String feedback = this.config.getString("email.feedback.path");
        if (feedback != null) {
            if (feedback.startsWith("/")) {
                feedback = appUrl + feedback;
            }
            context.put("feedback", (Object)feedback);
        }
        context.put("urlPath", (Object)this.config.getString("email.url.path", "security/login!login.action"));
        context.put("authkey", (Object)authkey.getKey());
        context.put("accountId", (Object)authkey.getForPrincipal());
        SimpleDateFormat dateformatter = new SimpleDateFormat(this.config.getString("application.timestamp"), Locale.US);
        context.put("requestedOn", (Object)dateformatter.format(authkey.getDateCreated()));
        if (authkey.getDateExpires() != null) {
            context.put("expiresOn", (Object)dateformatter.format(authkey.getDateExpires()));
        } else {
            context.put("expiresOn", (Object)"(does not expire)");
        }
        return context;
    }

    public UserConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(UserConfiguration config) {
        this.config = config;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }
}

