/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.integration.mail.MailGenerator;
import org.apache.archiva.redback.integration.mail.Mailer;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.UserValidationSettings;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service(value="mailer")
public class MailerImpl
implements Mailer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="mailGenerator#velocity")
    private MailGenerator generator;
    @Inject
    @Named(value="mailSender")
    private JavaMailSender javaMailSender;
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;

    @Override
    public void sendAccountValidationEmail(Collection<String> recipients, AuthenticationKey authkey, String baseUrl) {
        String content = this.generator.generateMail("newAccountValidationEmail", authkey, baseUrl);
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        UserValidationSettings validation = policy.getUserValidationSettings();
        this.sendMessage(recipients, validation.getEmailSubject(), content);
    }

    @Override
    public void sendPasswordResetEmail(Collection<String> recipients, AuthenticationKey authkey, String baseUrl) {
        String content = this.generator.generateMail("passwordResetEmail", authkey, baseUrl);
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        UserValidationSettings validation = policy.getUserValidationSettings();
        this.sendMessage(recipients, validation.getEmailSubject(), content);
    }

    @Override
    public void sendMessage(Collection<String> recipients, String subject, String content) {
        if (recipients.isEmpty()) {
            this.log.warn("Mail Not Sent - No mail recipients for email. subject [{}]", (Object)subject);
            return;
        }
        String fromAddress = this.config.getString("email.from.address");
        String fromName = this.config.getString("email.from.name");
        if (StringUtils.isEmpty((String)fromAddress)) {
            fromAddress = System.getProperty("user.name") + "@localhost";
        }
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            message.setSubject(subject);
            message.setText(content);
            InternetAddress from = new InternetAddress(fromAddress, fromName);
            message.setFrom((Address)from);
            ArrayList<InternetAddress> tos = new ArrayList<InternetAddress>();
            for (String mailbox : recipients) {
                InternetAddress to = new InternetAddress(mailbox.trim());
                tos.add(to);
            }
            message.setRecipients(Message.RecipientType.TO, tos.toArray(new Address[tos.size()]));
            this.log.debug("mail content {}", (Object)content);
            this.javaMailSender.send(message);
        }
        catch (AddressException e) {
            this.log.error("Unable to send message, subject [{}]", (Object)subject, (Object)e);
        }
        catch (MessagingException e) {
            this.log.error("Unable to send message, subject [{}]", (Object)subject, (Object)e);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unable to send message, subject [{}]", (Object)subject, (Object)e);
        }
    }
}

