/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.filter.authentication.digest;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.TokenBasedAuthenticationDataSource;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticationException;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.integration.filter.authentication.digest.Digest;
import org.apache.archiva.redback.integration.filter.authentication.digest.HttpDigestHeader;
import org.apache.archiva.redback.integration.filter.authentication.digest.NonceExpirationException;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="httpAuthenticator#digest")
public class HttpDigestAuthentication
extends HttpAuthenticator {
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    private int nonceLifetimeSeconds = 300;
    private String digestKey = "OrycteropusAfer";
    private String realm;

    public String getId() {
        return HttpDigestAuthentication.class.getName();
    }

    @Override
    public AuthenticationResult getAuthenticationResult(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        HttpSession httpSession = request.getSession(true);
        if (this.isAlreadyAuthenticated(httpSession)) {
            return this.getSecuritySession(httpSession).getAuthenticationResult();
        }
        TokenBasedAuthenticationDataSource authDataSource = new TokenBasedAuthenticationDataSource();
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            authHeader = request.getHeader("authorization");
        }
        if (authHeader != null && authHeader.startsWith("Digest ")) {
            String rawDigestHeader = authHeader.substring(7);
            HttpDigestHeader digestHeader = new HttpDigestHeader();
            digestHeader.parseClientHeader(rawDigestHeader, this.getRealm(), this.digestKey);
            User user = this.findUser(digestHeader.username);
            authDataSource.setPrincipal(user.getUsername());
            String serverSideHash = this.generateDigestHash(digestHeader, user.getPassword(), request.getMethod());
            if (!StringUtils.equals((String)serverSideHash, (String)digestHeader.response)) {
                throw new HttpAuthenticationException("Digest response was invalid.");
            }
        }
        return super.authenticate((AuthenticationDataSource)authDataSource, httpSession);
    }

    public User findUser(String username) throws HttpAuthenticationException {
        try {
            return this.userManager.findUser(username);
        }
        catch (UserNotFoundException e) {
            String msg = "Unable to find primary user '" + username + "'.";
            this.log.error(msg, (Throwable)e);
            throw new HttpAuthenticationException(msg, e);
        }
        catch (UserManagerException e) {
            this.log.error("issue find user {}, message: {}", new Object[]{username, e.getMessage(), e});
            throw new HttpAuthenticationException("issue find user " + username + ", message: " + e.getMessage(), e);
        }
    }

    @Override
    public void challenge(HttpServletRequest request, HttpServletResponse response, String realmName, AuthenticationException exception) throws IOException {
        StringBuilder authHeader = new StringBuilder();
        authHeader.append("Digest ");
        authHeader.append("realm=\"").append(realmName).append("\"");
        authHeader.append(", nonce=\"");
        long timestamp = System.currentTimeMillis() + (long)(this.nonceLifetimeSeconds * 1000);
        String hraw = String.valueOf(timestamp) + ":" + this.digestKey;
        String rawnonce = String.valueOf(timestamp) + ":" + Digest.md5Hex(hraw);
        authHeader.append(Base64.encodeBase64((byte[])rawnonce.getBytes()));
        authHeader.append("\"");
        authHeader.append(", qop=\"auth\"");
        if (exception instanceof NonceExpirationException) {
            authHeader.append(", stale=\"true\"");
        }
        response.addHeader("WWW-Authenticate", authHeader.toString());
        response.sendError(401, exception.getMessage());
    }

    private String generateDigestHash(HttpDigestHeader digestHeader, String password, String httpMethod) {
        String digest;
        String a1 = Digest.md5Hex(digestHeader.username + ":" + this.realm + ":" + password);
        String a2 = Digest.md5Hex(httpMethod + ":" + digestHeader.uri);
        if (StringUtils.isEmpty((String)digestHeader.qop)) {
            digest = a1 + ":" + digestHeader.nonce + ":" + a2;
        } else if (StringUtils.equals((String)"auth", (String)digestHeader.qop)) {
            digest = a1 + ":" + digestHeader.nonce + ":" + digestHeader.nc + ":" + digestHeader.cnonce + ":" + digestHeader.qop + ":" + a2;
        } else {
            throw new IllegalStateException("Http Digest Parameter [qop] with value of [" + digestHeader.qop + "] is unsupported.");
        }
        return Digest.md5Hex(digest);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

