/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.checks.security;

import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#required-roles")
public class RequiredRolesEnvironmentCheck
implements EnvironmentCheck {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private RoleManager roleManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            this.log.info("Checking the existence of required roles.");
            try {
                if (!this.roleManager.roleExists("registered-user")) {
                    violations.add("unable to validate existence of the registered-user role");
                }
                if (!this.roleManager.roleExists("user-administrator")) {
                    violations.add("unable to validate existence of the user-administator role");
                }
                if (!this.roleManager.roleExists("system-administrator")) {
                    violations.add("unable to validate existence of the system-administrator role");
                }
            }
            catch (RoleManagerException e) {
                violations.add("unable to check required roles: " + e.getMessage());
            }
            this.checked = true;
        }
    }
}

