/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.checks.security;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#guest-user-check")
public class GuestUserEnvironmentCheck
implements EnvironmentCheck {
    @Inject
    private RoleManager roleManager;
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            UserManager userManager = this.securitySystem.getUserManager();
            UserSecurityPolicy policy = this.securitySystem.getPolicy();
            User guest = null;
            try {
                guest = userManager.getGuestUser();
            }
            catch (UserManagerException e) {
                policy.setEnabled(false);
                try {
                    guest = userManager.createGuestUser();
                }
                catch (UserManagerException ume) {
                    violations.add("unable to initialize guest user properly: " + ume.getMessage());
                    this.checked = true;
                    return;
                }
                policy.setEnabled(true);
            }
            if (guest != null) {
                try {
                    this.roleManager.assignRole(this.config.getString("redback.default.role.guest.id", "guest"), guest.getUsername());
                }
                catch (RoleManagerException rpe) {
                    violations.add("unable to initialize guest user properly: " + rpe.getMessage());
                }
            } else {
                violations.add("cannot find neither create guest user");
            }
            this.checked = true;
        }
    }
}

