/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.checks.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#adminAutoCreateCheck")
public class AdminAutoCreateCheck
implements EnvironmentCheck {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String FORCE_ADMIN_FILE_PATH = "redback.admin.creation.file";
    public static final String ADMIN_FULL_NAME_KEY = "redback.admin.fullname";
    public static final String ADMIN_EMAIL_KEY = "redback.admin.email";
    public static final String ADMIN_PASSWORD_KEY = "redback.admin.password";
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    protected SecuritySystem securitySystem;
    @Inject
    private RoleManager roleManager;
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;

    public void validateEnvironment(List<String> violations) {
        try {
            User user = this.userManager.findUser(this.getAdminUid());
            if (user == null) {
                this.useForceAdminCreationFile();
            }
        }
        catch (UserNotFoundException e) {
            this.useForceAdminCreationFile();
        }
        catch (UserManagerException e) {
            this.useForceAdminCreationFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useForceAdminCreationFile() {
        try {
            String forceAdminFilePath = System.getProperty(FORCE_ADMIN_FILE_PATH);
            if (StringUtils.isBlank((String)forceAdminFilePath)) {
                this.log.info("{} system props is empty don't use an auto creation admin ", (Object)FORCE_ADMIN_FILE_PATH);
                return;
            }
            File file = new File(forceAdminFilePath);
            if (!file.exists()) {
                this.log.warn("file set in sysprops {} not exists skip admin auto creation", (Object)FORCE_ADMIN_FILE_PATH);
                return;
            }
            this.log.debug("user {} not found try auto creation", (Object)this.getAdminUid());
            Properties properties = new Properties();
            FileInputStream fis = new FileInputStream(file);
            try {
                properties.load(fis);
            }
            catch (Exception e) {
                this.log.warn("error loading properties from file {} skip admin auto creation", (Object)forceAdminFilePath);
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
            }
            String password = properties.getProperty(ADMIN_PASSWORD_KEY);
            String email = properties.getProperty(ADMIN_EMAIL_KEY);
            String fullName = properties.getProperty(ADMIN_FULL_NAME_KEY);
            if (StringUtils.isBlank((String)password)) {
                this.log.warn("property {} not set skip auto admin creation", (Object)ADMIN_PASSWORD_KEY);
                return;
            }
            if (StringUtils.isBlank((String)email)) {
                this.log.warn("property not set skip auto admin creation", (Object)ADMIN_EMAIL_KEY);
                return;
            }
            if (StringUtils.isBlank((String)fullName)) {
                this.log.warn("property {} not set skip auto admin creation", (Object)ADMIN_FULL_NAME_KEY);
                return;
            }
            User u = this.userManager.createUser(this.getAdminUid(), fullName, email);
            u.setPassword(password);
            u.setLocked(false);
            u.setPasswordChangeRequired(false);
            u.setPermanent(true);
            u.setValidated(true);
            u = this.userManager.addUser(u);
            u.setPassword(password);
            PasswordBasedAuthenticationDataSource authdatasource = new PasswordBasedAuthenticationDataSource();
            authdatasource.setPrincipal(u.getUsername());
            authdatasource.setPassword(u.getPassword());
            SecuritySession securitySession = this.securitySystem.authenticate((AuthenticationDataSource)authdatasource);
            if (securitySession.getAuthenticationResult().isAuthenticated()) {
                u = securitySession.getUser();
                u.setLastLoginDate(new Date());
                this.securitySystem.getUserManager().updateUser(u);
            }
            this.assignAdminRole(u);
        }
        catch (Exception e) {
            this.log.warn("failed to automatically create an admin account {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void assignAdminRole(User user) throws RoleManagerException {
        this.roleManager.assignRole("system-administrator", user.getUsername());
    }

    private String getAdminUid() {
        return this.config.getString("redback.default.admin");
    }
}

