/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.reflect;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.sisu.reflect.FileEntryIterator;
import org.eclipse.sisu.reflect.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZipEntryIterator
implements Iterator<String> {
    private String[] entryNames;
    private int index;

    ZipEntryIterator(URL url) {
        try {
            this.entryNames = "file".equals(url.getProtocol()) ? ZipEntryIterator.getEntryNames(new ZipFile(FileEntryIterator.toFile(url))) : ZipEntryIterator.getEntryNames(new ZipInputStream(Streams.open(url)));
        }
        catch (IOException iOException) {
            this.entryNames = new String[0];
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.entryNames.length;
    }

    @Override
    public String next() {
        return this.entryNames[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static String[] getEntryNames(ZipFile zipFile) throws IOException {
        try {
            String[] names = new String[zipFile.size()];
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            int i = 0;
            while (i < names.length) {
                names[i] = e.nextElement().getName();
                ++i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            zipFile.close();
        }
    }

    private static String[] getEntryNames(ZipInputStream zipStream) throws IOException {
        try {
            ArrayList<String> names = new ArrayList<String>(64);
            ZipEntry e = zipStream.getNextEntry();
            while (e != null) {
                names.add(e.getName());
                e = zipStream.getNextEntry();
            }
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
        finally {
            zipStream.close();
        }
    }
}

