/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.storage.maven2;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.archiva.proxy.common.WagonFactoryRequest;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryModelResolver
implements ModelResolver {
    private File basedir;
    private RepositoryPathTranslator pathTranslator;
    private WagonFactory wagonFactory;
    private List<RemoteRepository> remoteRepositories;
    private ManagedRepository targetRepository;
    private static final Logger log = LoggerFactory.getLogger(RepositoryModelResolver.class);
    private static final String METADATA_FILENAME = "maven-metadata.xml";
    Map<String, NetworkProxy> networkProxyMap;
    private ManagedRepository managedRepository;

    public RepositoryModelResolver(File basedir, RepositoryPathTranslator pathTranslator) {
        this.basedir = basedir;
        this.pathTranslator = pathTranslator;
    }

    public RepositoryModelResolver(ManagedRepository managedRepository, RepositoryPathTranslator pathTranslator, WagonFactory wagonFactory, List<RemoteRepository> remoteRepositories, Map<String, NetworkProxy> networkProxiesMap, ManagedRepository targetRepository) {
        this(new File(managedRepository.getLocation()), pathTranslator);
        this.managedRepository = managedRepository;
        this.wagonFactory = wagonFactory;
        this.remoteRepositories = remoteRepositories;
        this.networkProxyMap = networkProxiesMap;
        this.targetRepository = targetRepository;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        String filename = artifactId + "-" + version + ".pom";
        File model = this.pathTranslator.toFile(this.basedir, groupId, artifactId, version, filename);
        if (!model.exists()) {
            File localSnapshotModel;
            if (StringUtils.contains((String)version, (String)"SNAPSHOT") && (localSnapshotModel = this.findTimeStampedSnapshotPom(groupId, artifactId, version, model.getParent())) != null) {
                return new FileModelSource(localSnapshotModel);
            }
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                try {
                    boolean success = this.getModelFromProxy(remoteRepository, groupId, artifactId, version, filename);
                    if (!success || !model.exists()) continue;
                    log.info("Model '{}' successfully retrieved from remote repository '{}'", (Object)model.getAbsolutePath(), (Object)remoteRepository.getId());
                    break;
                }
                catch (ResourceDoesNotExistException e) {
                    log.info("An exception was caught while attempting to retrieve model '{}' from remote repository '{}'.Reason:{}", new Object[]{model.getAbsolutePath(), remoteRepository.getId(), e.getMessage()});
                }
                catch (Exception e) {
                    log.warn("An exception was caught while attempting to retrieve model '{}' from remote repository '{}'.Reason:{}", new Object[]{model.getAbsolutePath(), remoteRepository.getId(), e.getMessage()});
                }
            }
        }
        return new FileModelSource(model);
    }

    protected File findTimeStampedSnapshotPom(String groupId, String artifactId, String version, String parentDirectory) {
        File mavenMetadata = new File(parentDirectory, METADATA_FILENAME);
        if (mavenMetadata.exists()) {
            try {
                ArchivaRepositoryMetadata archivaRepositoryMetadata = MavenMetadataReader.read((File)mavenMetadata);
                SnapshotVersion snapshotVersion = archivaRepositoryMetadata.getSnapshotVersion();
                if (snapshotVersion != null) {
                    String lastVersion = snapshotVersion.getTimestamp();
                    int buildNumber = snapshotVersion.getBuildNumber();
                    String snapshotPath = StringUtils.replaceChars((String)groupId, (char)'.', (char)'/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + StringUtils.remove((String)version, (String)"-SNAPSHOT") + '-' + lastVersion + '-' + buildNumber + ".pom";
                    log.debug("use snapshot path {} for maven coordinate {}:{}:{}", new Object[]{snapshotPath, groupId, artifactId, version});
                    File model = new File(this.basedir, snapshotPath);
                    if (model.exists()) {
                        return model;
                    }
                }
            }
            catch (XMLException e) {
                log.warn("fail to read {}, {}", (Object)mavenMetadata.getAbsolutePath(), (Object)e.getCause());
            }
        }
        return null;
    }

    public void addRepository(org.apache.maven.model.Repository repository) throws InvalidRepositoryException {
    }

    public ModelResolver newCopy() {
        return new RepositoryModelResolver(this.managedRepository, this.pathTranslator, this.wagonFactory, this.remoteRepositories, this.networkProxyMap, this.targetRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getModelFromProxy(RemoteRepository remoteRepository, String groupId, String artifactId, String version, String filename) throws AuthorizationException, TransferFailedException, ResourceDoesNotExistException, WagonFactoryException, XMLException, IOException {
        boolean success;
        block19: {
            success = false;
            File tmpMd5 = null;
            File tmpSha1 = null;
            File tmpResource = null;
            String artifactPath = this.pathTranslator.toPath(groupId, artifactId, version, filename);
            File resource = new File(this.targetRepository.getLocation(), artifactPath);
            File workingDirectory = this.createWorkingDirectory(this.targetRepository.getLocation());
            try {
                Wagon wagon = null;
                try {
                    String protocol = this.getProtocol(remoteRepository.getUrl());
                    NetworkProxy networkProxy = this.networkProxyMap.get(remoteRepository.getId());
                    wagon = this.wagonFactory.getWagon(new WagonFactoryRequest("wagon#" + protocol, remoteRepository.getExtraHeaders()).networkProxy(networkProxy));
                    if (wagon == null) {
                        throw new RuntimeException("Unsupported remote repository protocol: " + protocol);
                    }
                    boolean connected = this.connectToRepository(wagon, remoteRepository);
                    if (connected) {
                        tmpResource = new File(workingDirectory, filename);
                        if (VersionUtil.isSnapshot((String)version)) {
                            File tmpMetadataResource = new File(workingDirectory, METADATA_FILENAME);
                            String metadataPath = StringUtils.substringBeforeLast((String)artifactPath, (String)"/") + "/" + METADATA_FILENAME;
                            wagon.get(this.addParameters(metadataPath, remoteRepository), tmpMetadataResource);
                            log.debug("Successfully downloaded metadata.");
                            ArchivaRepositoryMetadata metadata = MavenMetadataReader.read((File)tmpMetadataResource);
                            SnapshotVersion snapshotVersion = metadata.getSnapshotVersion();
                            String timestampVersion = version;
                            if (snapshotVersion != null) {
                                timestampVersion = timestampVersion.substring(0, timestampVersion.length() - 8);
                                timestampVersion = timestampVersion + snapshotVersion.getTimestamp() + "-" + snapshotVersion.getBuildNumber();
                                filename = artifactId + "-" + timestampVersion + ".pom";
                                artifactPath = this.pathTranslator.toPath(groupId, artifactId, version, filename);
                                log.debug("New artifactPath :{}", (Object)artifactPath);
                            }
                        }
                        log.info("Retrieving {} from {}", (Object)artifactPath, (Object)remoteRepository.getName());
                        wagon.get(this.addParameters(artifactPath, remoteRepository), tmpResource);
                        log.debug("Downloaded successfully.");
                        tmpSha1 = this.transferChecksum(wagon, remoteRepository, artifactPath, tmpResource, workingDirectory, ".sha1");
                        tmpMd5 = this.transferChecksum(wagon, remoteRepository, artifactPath, tmpResource, workingDirectory, ".md5");
                    }
                }
                finally {
                    if (wagon != null) {
                        try {
                            wagon.disconnect();
                        }
                        catch (ConnectionException e) {
                            log.warn("Unable to disconnect wagon.", (Throwable)e);
                        }
                    }
                }
                if (resource == null) break block19;
                String string = resource.getAbsolutePath().intern();
                synchronized (string) {
                    File directory = resource.getParentFile();
                    this.moveFileIfExists(tmpMd5, directory);
                    this.moveFileIfExists(tmpSha1, directory);
                    this.moveFileIfExists(tmpResource, directory);
                    success = true;
                }
            }
            finally {
                FileUtils.deleteQuietly((File)workingDirectory);
            }
        }
        return success;
    }

    private boolean connectToRepository(Wagon wagon, RemoteRepository remoteRepository) {
        boolean connected;
        NetworkProxy proxyConnector = this.networkProxyMap.get(remoteRepository.getId());
        ProxyInfo networkProxy = null;
        if (proxyConnector != null) {
            networkProxy = new ProxyInfo();
            networkProxy.setType(proxyConnector.getProtocol());
            networkProxy.setHost(proxyConnector.getHost());
            networkProxy.setPort(proxyConnector.getPort());
            networkProxy.setUserName(proxyConnector.getUsername());
            networkProxy.setPassword(proxyConnector.getPassword());
            String msg = "Using network proxy " + networkProxy.getHost() + ":" + networkProxy.getPort() + " to connect to remote repository " + remoteRepository.getUrl();
            if (networkProxy.getNonProxyHosts() != null) {
                msg = msg + "; excluding hosts: " + networkProxy.getNonProxyHosts();
            }
            if (StringUtils.isNotBlank((String)networkProxy.getUserName())) {
                msg = msg + "; as user: " + networkProxy.getUserName();
            }
            log.debug(msg);
        }
        AuthenticationInfo authInfo = null;
        String username = remoteRepository.getUserName();
        String password = remoteRepository.getPassword();
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            log.debug("Using username {} to connect to remote repository {}", (Object)username, (Object)remoteRepository.getUrl());
            authInfo = new AuthenticationInfo();
            authInfo.setUserName(username);
            authInfo.setPassword(password);
        }
        int timeoutInMilliseconds = remoteRepository.getTimeout() * 1000;
        wagon.setReadTimeout(timeoutInMilliseconds);
        wagon.setTimeout(timeoutInMilliseconds);
        try {
            Repository wagonRepository = new Repository(remoteRepository.getId(), remoteRepository.getUrl());
            if (networkProxy != null) {
                wagon.connect(wagonRepository, authInfo, networkProxy);
            } else {
                wagon.connect(wagonRepository, authInfo);
            }
            connected = true;
        }
        catch (ConnectionException | AuthenticationException e) {
            log.error("Could not connect to {}:{} ", (Object)remoteRepository.getName(), (Object)e.getMessage());
            connected = false;
        }
        return connected;
    }

    private File transferChecksum(Wagon wagon, RemoteRepository remoteRepository, String remotePath, File resource, File workingDir, String ext) throws AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        File destFile = new File(workingDir, resource.getName() + ext);
        String remoteChecksumPath = remotePath + ext;
        log.info("Retrieving {} from {}", (Object)remoteChecksumPath, (Object)remoteRepository.getName());
        wagon.get(this.addParameters(remoteChecksumPath, remoteRepository), destFile);
        log.debug("Downloaded successfully.");
        return destFile;
    }

    private String getProtocol(String url) {
        String protocol = StringUtils.substringBefore((String)url, (String)":");
        return protocol;
    }

    private File createWorkingDirectory(String targetRepository) throws IOException {
        return Files.createTempDirectory("temp", new FileAttribute[0]).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFileIfExists(File fileToMove, File directory) {
        block9: {
            if (fileToMove != null && fileToMove.exists()) {
                File newLocation = new File(directory, fileToMove.getName());
                if (newLocation.exists() && !newLocation.delete()) {
                    throw new RuntimeException("Unable to overwrite existing target file: " + newLocation.getAbsolutePath());
                }
                newLocation.getParentFile().mkdirs();
                if (!fileToMove.renameTo(newLocation)) {
                    log.warn("Unable to rename tmp file to its final name... resorting to copy command.");
                    try {
                        FileUtils.copyFile((File)fileToMove, (File)newLocation);
                    }
                    catch (IOException e) {
                        if (newLocation.exists()) {
                            log.error("Tried to copy file {} to {} but file with this name already exists.", (Object)fileToMove.getName(), (Object)newLocation.getAbsolutePath());
                            break block9;
                        }
                        throw new RuntimeException("Cannot copy tmp file " + fileToMove.getAbsolutePath() + " to its final location", e);
                    }
                    finally {
                        FileUtils.deleteQuietly((File)fileToMove);
                    }
                }
            }
        }
    }

    protected String addParameters(String path, RemoteRepository remoteRepository) {
        if (remoteRepository.getExtraParameters().isEmpty()) {
            return path;
        }
        boolean question = false;
        StringBuilder res = new StringBuilder(path == null ? "" : path);
        for (Map.Entry entry : remoteRepository.getExtraParameters().entrySet()) {
            if (question) continue;
            res.append('?').append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return res.toString();
    }
}

