/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.rules;

import javax.annotation.PostConstruct;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.rules.AbstractPasswordRule;
import org.apache.archiva.redback.users.User;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#no-whitespaces")
public class WhitespacePasswordRule
extends AbstractPasswordRule {
    public static final String NO_WHITE_SPACE_VIOLATION = "user.password.violation.whitespace.detected";

    @Override
    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    @Override
    public void testPassword(PasswordRuleViolations violations, User user) {
        if (user.getPassword() != null) {
            char[] password = user.getPassword().toCharArray();
            for (int i = 0; i < password.length; ++i) {
                if (!Character.isWhitespace(password[i])) continue;
                violations.addViolation(NO_WHITE_SPACE_VIOLATION);
                return;
            }
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.enabled = this.config.getBoolean("security.policy.password.rule.nowhitespace.enabled");
    }
}

