/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.rules;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.rules.AbstractPasswordRule;
import org.apache.archiva.redback.users.User;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#reuse")
public class ReusePasswordRule
extends AbstractPasswordRule {
    public static final String REUSE_VIOLATION = "user.password.violation.reuse";
    private UserSecurityPolicy securityPolicy;

    @Override
    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
        this.securityPolicy = policy;
    }

    @Override
    public boolean requiresSecurityPolicy() {
        return true;
    }

    public int getPreviousPasswordCount() {
        if (this.securityPolicy == null) {
            throw new IllegalStateException("The security policy has not yet been set.");
        }
        return this.securityPolicy.getPreviousPasswordsCount();
    }

    private boolean hasReusedPassword(User user, String password) {
        if (this.securityPolicy == null) {
            throw new IllegalStateException("The security policy has not yet been set.");
        }
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String encodedPassword = this.securityPolicy.getPasswordEncoder().encodePassword(password);
        Iterator it = user.getPreviousEncodedPasswords().iterator();
        for (int checkCount = this.getPreviousPasswordCount(); it.hasNext() && checkCount >= 0; --checkCount) {
            String prevEncodedPassword = (String)it.next();
            if (!encodedPassword.equals(prevEncodedPassword)) continue;
            return true;
        }
        return false;
    }

    public void setPreviousPasswordCount(int previousPasswordCount) {
        this.securityPolicy.setPreviousPasswordsCount(previousPasswordCount);
    }

    @Override
    public void testPassword(PasswordRuleViolations violations, User user) {
        String password = user.getPassword();
        if (this.hasReusedPassword(user, password)) {
            violations.addViolation(REUSE_VIOLATION, new String[]{String.valueOf(this.getPreviousPasswordCount())});
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.enabled = this.config.getBoolean("security.policy.password.rule.reuse.enabled");
    }
}

