/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.rules;

import javax.annotation.PostConstruct;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.rules.AbstractPasswordRule;
import org.apache.archiva.redback.users.User;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#must-have")
public class MustHavePasswordRule
extends AbstractPasswordRule {
    public static final String MISSING_PASSWORD_VIOLATION = "user.password.violation.missing";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    @Override
    public void testPassword(PasswordRuleViolations violations, User user) {
        if (StringUtils.isEmpty((String)user.getPassword())) {
            violations.addViolation(MISSING_PASSWORD_VIOLATION);
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.enabled = this.config.getBoolean("security.policy.password.rule.musthave.enabled");
        this.logger.debug("{} enabled: {}", (Object)"security.policy.password.rule.musthave.enabled", (Object)this.enabled);
    }
}

