/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.rules;

import javax.annotation.PostConstruct;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.rules.AbstractPasswordRule;
import org.apache.archiva.redback.users.User;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#alpha-count")
public class AlphaPasswordRule
extends AbstractPasswordRule {
    private int minimumCount;

    private int countAlphaCharacters(String password) {
        int count = 0;
        if (StringUtils.isEmpty((String)password)) {
            return count;
        }
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isLetter(c)) continue;
            ++count;
        }
        return count;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public void setMinimumCount(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    @Override
    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    @Override
    public void testPassword(PasswordRuleViolations violations, User user) {
        if (this.countAlphaCharacters(user.getPassword()) < this.minimumCount) {
            violations.addViolation("user.password.violation.alpha", new String[]{String.valueOf(this.minimumCount)});
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.enabled = this.config.getBoolean("security.policy.password.rule.alphacount.enabled");
        this.minimumCount = this.config.getInt("security.policy.password.rule.alphacount.minimum");
    }
}

