/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.encoders;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.PasswordEncodingException;
import org.apache.archiva.redback.users.Messages;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class AbstractJAASPasswordEncoder
implements PasswordEncoder {
    private String algorithm;
    private Object systemSalt;

    public AbstractJAASPasswordEncoder(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setSystemSalt(Object salt) {
        this.systemSalt = salt;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        if (rawPass == null) {
            throw new IllegalArgumentException("rawPass parameter cannot be null.");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.algorithm);
            String precode = rawPass;
            if (salt != null) {
                precode = precode + "{" + salt + "}";
            }
            md.update(precode.getBytes(Charset.forName("UTF-8")));
            byte[] raw = md.digest();
            Base64 base64 = new Base64(0, new byte[0]);
            return base64.encodeToString(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PasswordEncodingException(Messages.getString((String)"password.encoder.no.such.algoritm", (Object)this.algorithm), e);
        }
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        if (StringUtils.isEmpty((String)encPass)) {
            return false;
        }
        String testPass = this.encodePassword(rawPass, salt);
        return encPass.equals(testPass);
    }

    @Override
    public String encodePassword(String rawPass) {
        return this.encodePassword(rawPass, this.systemSalt);
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass) {
        return this.isPasswordValid(encPass, rawPass, this.systemSalt);
    }
}

