/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.CookieSettings;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.PasswordRule;
import org.apache.archiva.redback.policy.PasswordRuleViolationException;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.PolicyContext;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.UserValidationSettings;
import org.apache.archiva.redback.policy.rules.MustHavePasswordRule;
import org.apache.archiva.redback.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="userSecurityPolicy")
public class DefaultUserSecurityPolicy
implements UserSecurityPolicy {
    private static final String ENABLEMENT_KEY = "UserSecurityPolicy:ENABLED";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private PasswordRule defaultPasswordRule = new MustHavePasswordRule();
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    @Named(value="passwordEncoder#sha256")
    private PasswordEncoder passwordEncoder;
    @Inject
    @Named(value="userValidationSettings")
    private UserValidationSettings userValidationSettings;
    @Inject
    @Named(value="cookieSettings#rememberMe")
    private CookieSettings rememberMeCookieSettings;
    @Inject
    @Named(value="cookieSettings#signon")
    private CookieSettings signonCookieSettings;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private List<PasswordRule> rules = new ArrayList<PasswordRule>(0);
    private int previousPasswordsCount;
    private int loginAttemptCount;
    private int passwordExpirationDays;
    private boolean passwordExpirationEnabled;
    private List<String> unlockableAccounts;

    @PostConstruct
    public void initialize() {
        this.configurePolicy();
        this.configureEncoder();
        if (this.rules == null) {
            this.rules = new ArrayList<PasswordRule>(1);
        }
        if (this.rules.isEmpty()) {
            this.addPasswordRule(this.defaultPasswordRule);
        }
    }

    private void configureEncoder() {
        String encoder = this.config.getString("security.policy.password.encoder");
        if (encoder != null) {
            this.passwordEncoder = (PasswordEncoder)this.applicationContext.getBean("passwordEncoder#" + encoder, PasswordEncoder.class);
        }
    }

    private void configurePolicy() {
        this.previousPasswordsCount = this.config.getInt("security.policy.password.previous.count");
        this.loginAttemptCount = this.config.getInt("security.policy.allowed.login.attempt");
        this.passwordExpirationEnabled = this.config.getBoolean("security.policy.password.expiration.enabled");
        this.passwordExpirationDays = this.config.getInt("security.policy.password.expiration.days");
        this.unlockableAccounts = this.config.getList("security.policy.unlockable.accounts");
    }

    @Override
    public String getId() {
        return "Default User Security Policy";
    }

    @Override
    public int getPreviousPasswordsCount() {
        return this.previousPasswordsCount;
    }

    @Override
    public List<String> getUnlockableAccounts() {
        if (this.unlockableAccounts == null) {
            this.unlockableAccounts = new ArrayList<String>(0);
        }
        return this.unlockableAccounts;
    }

    @Override
    public void setUnlockableAccounts(List<String> unlockableAccounts) {
        this.unlockableAccounts = unlockableAccounts;
    }

    @Override
    public void setPreviousPasswordsCount(int count) {
        this.previousPasswordsCount = count;
    }

    @Override
    public int getLoginAttemptCount() {
        return this.loginAttemptCount;
    }

    @Override
    public void setLoginAttemptCount(int count) {
        this.loginAttemptCount = count;
    }

    @Override
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Override
    public boolean isEnabled() {
        Boolean bool = (Boolean)PolicyContext.getContext().get(ENABLEMENT_KEY);
        return bool == null || bool != false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        PolicyContext.getContext().put(ENABLEMENT_KEY, enabled);
    }

    @Override
    public void addPasswordRule(PasswordRule rule) {
        rule.setUserSecurityPolicy(this);
        this.rules.add(rule);
    }

    @Override
    public List<PasswordRule> getPasswordRules() {
        return this.rules;
    }

    @Override
    public void setPasswordRules(List<PasswordRule> rules) {
        this.rules.clear();
        if (rules == null) {
            return;
        }
        for (PasswordRule rule : rules) {
            this.addPasswordRule(rule);
        }
    }

    @Override
    public void extensionPasswordExpiration(User user) throws MustChangePasswordException {
        if (this.passwordExpirationEnabled && !this.getUnlockableAccounts().contains(user.getUsername())) {
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.setTime(user.getLastPasswordChange());
            expirationDate.add(5, this.passwordExpirationDays);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                this.log.info("User '{}' flagged for password expiry (expired on: {})", (Object)user.getUsername(), (Object)expirationDate);
                user.setPasswordChangeRequired(true);
                throw new MustChangePasswordException("Password Expired, You must change your password.", user);
            }
        }
    }

    @Override
    public void extensionExcessiveLoginAttempts(User user) throws AccountLockedException {
        if (!this.getUnlockableAccounts().contains(user.getUsername())) {
            int attempt = user.getCountFailedLoginAttempts();
            user.setCountFailedLoginAttempts(++attempt);
            if (attempt >= this.loginAttemptCount) {
                this.log.info("User '{}' locked due to excessive login attempts: {}", (Object)user.getUsername(), (Object)attempt);
                user.setLocked(true);
                throw new AccountLockedException("Account " + user.getUsername() + " is locked.", user);
            }
        }
    }

    @Override
    public void extensionChangePassword(User user) throws PasswordRuleViolationException {
        this.extensionChangePassword(user, false);
    }

    @Override
    public void extensionChangePassword(User user, boolean passwordChangeRequired) throws PasswordRuleViolationException {
        this.validatePassword(user);
        user.setEncodedPassword(this.passwordEncoder.encodePassword(user.getPassword()));
        user.setPassword(null);
        ArrayList<String> previousPasswords = new ArrayList<String>(1);
        previousPasswords.add(user.getEncodedPassword());
        if (!user.getPreviousEncodedPasswords().isEmpty()) {
            int oldCount = Math.min(this.previousPasswordsCount - 1, user.getPreviousEncodedPasswords().size());
            List sublist = user.getPreviousEncodedPasswords().subList(0, oldCount);
            previousPasswords.addAll(sublist);
        }
        user.setPreviousEncodedPasswords(previousPasswords);
        user.setPasswordChangeRequired(passwordChangeRequired);
        user.setLastPasswordChange(new Date());
    }

    @Override
    public void validatePassword(User user) throws PasswordRuleViolationException {
        if (this.isEnabled()) {
            PasswordRuleViolations violations = new PasswordRuleViolations();
            for (PasswordRule rule : this.rules) {
                if (!rule.isEnabled()) continue;
                if (rule.requiresSecurityPolicy()) {
                    rule.setUserSecurityPolicy(this);
                }
                rule.testPassword(violations, user);
            }
            if (violations.hasViolations()) {
                PasswordRuleViolationException exception = new PasswordRuleViolationException();
                exception.setViolations(violations);
                throw exception;
            }
        }
        if (user.getPassword() == null) {
            user.setPassword("");
        }
    }

    @Override
    public int getPasswordExpirationDays() {
        return this.passwordExpirationDays;
    }

    @Override
    public void setPasswordExpirationDays(int passwordExpiry) {
        this.passwordExpirationDays = passwordExpiry;
    }

    @Override
    public UserValidationSettings getUserValidationSettings() {
        return this.userValidationSettings;
    }

    @Override
    public void setUserValidationSettings(UserValidationSettings settings) {
        this.userValidationSettings = settings;
    }

    @Override
    public CookieSettings getRememberMeCookieSettings() {
        return this.rememberMeCookieSettings;
    }

    @Override
    public CookieSettings getSignonCookieSettings() {
        return this.signonCookieSettings;
    }

    public UserConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(UserConfiguration config) {
        this.config = config;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setRememberMeCookieSettings(CookieSettings rememberMeCookieSettings) {
        this.rememberMeCookieSettings = rememberMeCookieSettings;
    }

    public void setSignonCookieSettings(CookieSettings signonCookieSettings) {
        this.signonCookieSettings = signonCookieSettings;
    }

    public void setRules(List<PasswordRule> rules) {
        this.rules = rules;
    }

    public void setDefaultPasswordRule(PasswordRule defaultPasswordRule) {
        this.defaultPasswordRule = defaultPasswordRule;
    }
}

